<?php

/**
 * This is the model class for table "hrd_t_request_duty_letter".
 *
 * The followings are the available columns in table 'hrd_t_request_duty_letter':
 * @property integer $rdl_id
 * @property integer $requester_id
 * @property string $duty_category
 * @property string $duty_concerning
 * @property string $duty_location
 * @property string $contactable_information
 * @property string $depart_date
 * @property string $return_date
 * @property string $starting_date
 * @property string $finishing_date
 * @property integer $status_id
 * @property string $request_date
 * @property string $response_date
 * @property string $rejection_reason
 * @property string $created_by
 * @property string $created_date
 * @property string $created_ip
 * @property string $updated_by
 * @property string $updated_date
 * @property string $updated_ip
 *
 * The followings are the available model relations:
 * @property HrdDRequestDutyLetter[] $hrdDRequestDutyLetters
 * @property HrdMDutyLetter[] $hrdMDutyLetters
 * @property HrdRStatus $status
 */
class HrdTRequestDutyLetter extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return HrdTRequestDutyLetter the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'hrd_t_request_duty_letter';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('requester_id, duty_category, duty_concerning, duty_location, contactable_information, depart_date, return_date, starting_date, finishing_date, status_id', 'required'),
			array('requester_id, status_id', 'numerical', 'integerOnly'=>true),
			array('duty_category, duty_concerning, duty_location, contactable_information, created_by, updated_by', 'length', 'max'=>200),
			array('created_ip, updated_ip', 'length', 'max'=>15),
			array('request_date, response_date, rejection_reason, created_date, updated_date', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('rdl_id, requester_id, duty_category, duty_concerning, duty_location, contactable_information, depart_date, return_date, starting_date, finishing_date, status_id, request_date, response_date, rejection_reason, created_by, created_date, created_ip, updated_by, updated_date, updated_ip', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'hrdDRequestDutyLetters' => array(self::HAS_MANY, 'HrdDRequestDutyLetter', 'id_hrd_t_request_duty_letter'),
			'hrdMDutyLetters' => array(self::HAS_MANY, 'HrdMDutyLetter', 'request_id'),
			'status' => array(self::BELONGS_TO, 'HrdRStatus', 'status_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'rdl_id' => 'Rdl',
			'requester_id' => 'Requester',
			'duty_category' => 'Duty Category',
			'duty_concerning' => 'Duty Concerning',
			'duty_location' => 'Duty Location',
			'contactable_information' => 'Contactable Information',
			'depart_date' => 'Depart Date',
			'return_date' => 'Return Date',
			'starting_date' => 'Starting Date',
			'finishing_date' => 'Finishing Date',
			'status_id' => 'Status',
			'request_date' => 'Request Date',
			'response_date' => 'Response Date',
			'rejection_reason' => 'Rejection Reason',
			'created_by' => 'Created By',
			'created_date' => 'Created Date',
			'created_ip' => 'Created Ip',
			'updated_by' => 'Updated By',
			'updated_date' => 'Updated Date',
			'updated_ip' => 'Updated Ip',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('rdl_id',$this->rdl_id);
		$criteria->compare('requester_id',$this->requester_id);
		$criteria->compare('duty_category',$this->duty_category,true);
		$criteria->compare('duty_concerning',$this->duty_concerning,true);
		$criteria->compare('duty_location',$this->duty_location,true);
		$criteria->compare('contactable_information',$this->contactable_information,true);
		$criteria->compare('depart_date',$this->depart_date,true);
		$criteria->compare('return_date',$this->return_date,true);
		$criteria->compare('starting_date',$this->starting_date,true);
		$criteria->compare('finishing_date',$this->finishing_date,true);
		$criteria->compare('status_id',$this->status_id);
		$criteria->compare('request_date',$this->request_date,true);
		$criteria->compare('response_date',$this->response_date,true);
		$criteria->compare('rejection_reason',$this->rejection_reason,true);
		$criteria->compare('created_by',$this->created_by,true);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('created_ip',$this->created_ip,true);
		$criteria->compare('updated_by',$this->updated_by,true);
		$criteria->compare('updated_date',$this->updated_date,true);
		$criteria->compare('updated_ip',$this->updated_ip,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	protected function afterValidate(){
        if ($this->isNewRecord){
            $this->created_date=new CDbExpression('NOW()');
            $this->created_by=Yii::app()->user->getId();
            $this->created_ip=Yii::app()->request->getUserHostAddress();


        }else{
            $this->updated_date=new CDbExpression('NOW()');
            $this->updated_by=Yii::app()->user->getId();
            $this->updated_ip=Yii::app()->request->getUserHostAddress();
        }
    }
}