<?php

/**
 * This is the model class for table "hrd_r_status".
 *
 * The followings are the available columns in table 'hrd_r_status':
 * @property integer $status_id
 * @property string $status
 * @property string $created_by
 * @property string $created_date
 * @property string $created_ip
 * @property string $updated_by
 * @property string $updated_date
 * @property string $updated_ip
 *
 * The followings are the available model relations:
 * @property HrdMDutyLetter[] $hrdMDutyLetters
 * @property HrdTRequestDutyLetter[] $hrdTRequestDutyLetters
 */
class HrdStatus extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return HrdStatus the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'hrd_r_status';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('status', 'required'),
			array('status, created_by, updated_by', 'length', 'max'=>255),
			array('created_ip, updated_ip', 'length', 'max'=>15),
			array('created_date, updated_date', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('status_id, status, created_by, created_date, created_ip, updated_by, updated_date, updated_ip', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'hrdMDutyLetters' => array(self::HAS_MANY, 'HrdMDutyLetter', 'status_id'),
			'hrdTRequestDutyLetters' => array(self::HAS_MANY, 'HrdTRequestDutyLetter', 'status_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'status_id' => 'Status',
			'status' => 'Status',
			'created_by' => 'Created By',
			'created_date' => 'Created Date',
			'created_ip' => 'Created Ip',
			'updated_by' => 'Updated By',
			'updated_date' => 'Updated Date',
			'updated_ip' => 'Updated Ip',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('status_id',$this->status_id);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('created_by',$this->created_by,true);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('created_ip',$this->created_ip,true);
		$criteria->compare('updated_by',$this->updated_by,true);
		$criteria->compare('updated_date',$this->updated_date,true);
		$criteria->compare('updated_ip',$this->updated_ip,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}