<?php

/**
 * This is the model class for table "hrd_m_pegawai".
 *
 * The followings are the available columns in table 'hrd_m_pegawai':
 * @property integer $nip
 * @property string $nama
 * @property string $alias
 * @property string $jenis_kelamin
 * @property string $tempat_lahir
 * @property string $t_lahir
 * @property string $status_kawin
 * @property string $d_awal_kerja
 * @property string $status_now
 * @property string $grup_awal
 * @property string $grup_now
 * @property string $unit_kerja
 * @property string $ukuran_baju
 * @property string $status_kepeg
 * @property integer $user_id
 * @property string $pendidikan_awal
 * @property string $pendidikan_now
 * @property string $golongan_awal
 * @property string $golongan_now
 * @property string $prefix_gelar
 * @property string $suffix_gelar
 * @property string $created_by
 * @property string $created_date
 * @property string $created_ip
 * @property string $updated_by
 * @property string $updated_date
 * @property string $updated_ip
 *
 * The followings are the available model relations:
 * @property HrdDPegawai[] $hrdDPegawais
 * @property HrdMDosen[] $hrdMDosens
 * @property HrdMStaf[] $hrdMStafs
 */
class HrdMPegawai extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return HrdMPegawai the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'hrd_m_pegawai';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('nama, alias, jenis_kelamin, tempat_lahir, t_lahir, status_kawin, d_awal_kerja, status_now, grup_awal, grup_now, unit_kerja, ukuran_baju, status_kepeg, user_id, pendidikan_awal, pendidikan_now, golongan_awal, golongan_now, prefix_gelar, suffix_gelar', 'required'),
			array('user_id', 'numerical', 'integerOnly'=>true),
			array('nama, created_by, updated_by', 'length', 'max'=>200),
			array('alias, created_ip, updated_ip', 'length', 'max'=>15),
			array('jenis_kelamin', 'length', 'max'=>6),
			array('tempat_lahir, status_now, grup_awal, grup_now, unit_kerja', 'length', 'max'=>100),
			array('status_kawin', 'length', 'max'=>25),
			array('ukuran_baju', 'length', 'max'=>3),
			array('status_kepeg, pendidikan_awal, pendidikan_now, golongan_awal, golongan_now, prefix_gelar, suffix_gelar', 'length', 'max'=>45),
			array('created_date, updated_date', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('nip, nama, alias, jenis_kelamin, tempat_lahir, t_lahir, status_kawin, d_awal_kerja, status_now, grup_awal, grup_now, unit_kerja, ukuran_baju, status_kepeg, user_id, pendidikan_awal, pendidikan_now, golongan_awal, golongan_now, prefix_gelar, suffix_gelar, created_by, created_date, created_ip, updated_by, updated_date, updated_ip', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'hrdDPegawais' => array(self::HAS_MANY, 'HrdDPegawai', 'nip'),
			'hrdMDosens' => array(self::HAS_MANY, 'HrdMDosen', 'nip'),
			'hrdMStafs' => array(self::HAS_MANY, 'HrdMStaf', 'nip'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'nip' => 'Nip',
			'nama' => 'Nama',
			'alias' => 'Alias',
			'jenis_kelamin' => 'Jenis Kelamin',
			'tempat_lahir' => 'Tempat Lahir',
			't_lahir' => 'T Lahir',
			'status_kawin' => 'Status Kawin',
			'd_awal_kerja' => 'D Awal Kerja',
			'status_now' => 'Status Now',
			'grup_awal' => 'Grup Awal',
			'grup_now' => 'Grup Now',
			'unit_kerja' => 'Unit Kerja',
			'ukuran_baju' => 'Ukuran Baju',
			'status_kepeg' => 'Status Kepeg',
			'user_id' => 'User',
			'pendidikan_awal' => 'Pendidikan Awal',
			'pendidikan_now' => 'Pendidikan Now',
			'golongan_awal' => 'Golongan Awal',
			'golongan_now' => 'Golongan Now',
			'prefix_gelar' => 'Prefix Gelar',
			'suffix_gelar' => 'Suffix Gelar',
			'created_by' => 'Created By',
			'created_date' => 'Created Date',
			'created_ip' => 'Created Ip',
			'updated_by' => 'Updated By',
			'updated_date' => 'Updated Date',
			'updated_ip' => 'Updated Ip',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('nip',$this->nip);
		$criteria->compare('nama',$this->nama,true);
		$criteria->compare('alias',$this->alias,true);
		$criteria->compare('jenis_kelamin',$this->jenis_kelamin,true);
		$criteria->compare('tempat_lahir',$this->tempat_lahir,true);
		$criteria->compare('t_lahir',$this->t_lahir,true);
		$criteria->compare('status_kawin',$this->status_kawin,true);
		$criteria->compare('d_awal_kerja',$this->d_awal_kerja,true);
		$criteria->compare('status_now',$this->status_now,true);
		$criteria->compare('grup_awal',$this->grup_awal,true);
		$criteria->compare('grup_now',$this->grup_now,true);
		$criteria->compare('unit_kerja',$this->unit_kerja,true);
		$criteria->compare('ukuran_baju',$this->ukuran_baju,true);
		$criteria->compare('status_kepeg',$this->status_kepeg,true);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('pendidikan_awal',$this->pendidikan_awal,true);
		$criteria->compare('pendidikan_now',$this->pendidikan_now,true);
		$criteria->compare('golongan_awal',$this->golongan_awal,true);
		$criteria->compare('golongan_now',$this->golongan_now,true);
		$criteria->compare('prefix_gelar',$this->prefix_gelar,true);
		$criteria->compare('suffix_gelar',$this->suffix_gelar,true);
		$criteria->compare('created_by',$this->created_by,true);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('created_ip',$this->created_ip,true);
		$criteria->compare('updated_by',$this->updated_by,true);
		$criteria->compare('updated_date',$this->updated_date,true);
		$criteria->compare('updated_ip',$this->updated_ip,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}