<?php

class HrdTRequestDutyLetterController extends Controller
{
/**
* @var string the default layout for the views. Defaults to '//layouts/column2', meaning
* using two-column layout. See 'protected/views/layouts/column2.php'.
*/
public $layout='//layouts/column2';

/**
* @return array action filters
*/
public function filters()
{
return array(
'accessControl', // perform access control for CRUD operations
);
}

/**
* Specifies the access control rules.
* This method is used by the 'accessControl' filter.
* @return array access control rules
*/
public function accessRules()
{
return array(
array('allow',  // allow all users to perform 'index' and 'view' actions
'actions'=>array('index','view'),
'users'=>array('*'),
),
array('allow', // allow authenticated user to perform 'create' and 'update' actions
'actions'=>array('create','update'),
'users'=>array('@'),
),
array('allow', // allow admin user to perform 'admin' and 'delete' actions
'actions'=>array('admin','delete'),
'users'=>array('admin'),
),
array('deny',  // deny all users
'users'=>array('*'),
),
);
}

/**
* Displays a particular model.
* @param integer $id the ID of the model to be displayed
*/
public function actionView($id)
{
$this->render('view',array(
'model'=>$this->loadModel($id),
));
}

/**
* Creates a new model.
* If creation is successful, the browser will be redirected to the 'view' page.
*/
public function actionCreate()
{
$model=new HrdTRequestDutyLetter;

// Uncomment the following line if AJAX validation is needed
$this->performAjaxValidation($model);

if(isset($_POST['HrdTRequestDutyLetter']))
{
    $model->attributes=$_POST['HrdTRequestDutyLetter'];
    $model->status_id = 1;
    $tempReqID = HrdMPegawai::model()->findByAttributes(array('nama'=>$model->requester_id));
	if($model->depart_date != null && $model->return_date != null && $model->starting_date != null && $model->finishing_date != null && $model->requester_id != null){
    // Convert to db format date
		$tempDTime = explode('/', $model->depart_date);
		$model->depart_date = $tempDTime[2]."-".$tempDTime[0]."-".$tempDTime[1];
		$tempRDate = explode('/', $model->return_date);
		$model->return_date = $tempRDate[2]."-".$tempRDate[0]."-".$tempRDate[1];
		$tempSDate = explode('/', $model->starting_date);
		$model->starting_date = $tempSDate[2]."-".$tempSDate[0]."-".$tempSDate[1];
		$tempFDate = explode('/', $model->finishing_date);
		$model->finishing_date = $tempFDate[2]."-".$tempFDate[0]."-".$tempFDate[1];
		$model->requester_id = (int)$tempReqID->nip;
    /* - - - */
	}
    if($model->save()){
		$model2_forID = HrdTRequestDutyLetter::model()->findByAttributes(array(
			'requester_id'=>$model->requester_id, 
			'duty_category'=>$model->duty_category, 
			'duty_concerning'=>$model->duty_concerning,
			'duty_location'=>$model->duty_location,
			'contactable_information'=>$model->contactable_information,
			'depart_date'=>$model->depart_date,
			'return_date'=>$model->return_date,
			'starting_date'=>$model->starting_date,
			'finishing_date'=>$model->finishing_date
		));
        $this->redirect(array('/surat_tugas/HrdDRequestDutyLetter/Create', 'ID_MRequestDutyLetter'=>1));//$model2_forID->rdl_id));
		}
    }

    $this->render('create',array(
        'model'=>$model,
    ));
}

/**
* Updates a particular model.
* If update is successful, the browser will be redirected to the 'view' page.
* @param integer $id the ID of the model to be updated
*/
public function actionUpdate($id)
{
$model=$this->loadModel($id);

// Uncomment the following line if AJAX validation is needed
// $this->performAjaxValidation($model);

if(isset($_POST['HrdTRequestDutyLetter']))
{
$model->attributes=$_POST['HrdTRequestDutyLetter'];
if($model->save())
$this->redirect(array('view','id'=>$model->rdl_id));
}

$this->render('update',array(
'model'=>$model,
));
}

/**
* Deletes a particular model.
* If deletion is successful, the browser will be redirected to the 'admin' page.
* @param integer $id the ID of the model to be deleted
*/
public function actionDelete($id)
{
if(Yii::app()->request->isPostRequest)
{
// we only allow deletion via POST request
$this->loadModel($id)->delete();

// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
if(!isset($_GET['ajax']))
$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
}
else
throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
}

/**
* Lists all models.
*/
public function actionIndex()
{
$dataProvider=new CActiveDataProvider('HrdTRequestDutyLetter');
$this->render('index',array(
'dataProvider'=>$dataProvider,
));
}

/**
* Manages all models.
*/
public function actionAdmin()
{
$model=new HrdTRequestDutyLetter('search');
$model->unsetAttributes();  // clear any default values
if(isset($_GET['HrdTRequestDutyLetter']))
$model->attributes=$_GET['HrdTRequestDutyLetter'];

$this->render('admin',array(
'model'=>$model,
));
}

/**
* Returns the data model based on the primary key given in the GET variable.
* If the data model is not found, an HTTP exception will be raised.
* @param integer the ID of the model to be loaded
*/
public function loadModel($id)
{
$model=HrdTRequestDutyLetter::model()->findByPk($id);
if($model===null)
throw new CHttpException(404,'The requested page does not exist.');
return $model;
}

/**
* Performs the AJAX validation.
* @param CModel the model to be validated
*/
protected function performAjaxValidation($model)
{
if(isset($_POST['ajax']) && $_POST['ajax']==='hrd-trequest-duty-letter-form')
{
echo CActiveForm::validate($model);
Yii::app()->end();
}
}
}
