<?php

class HrdTReportDutyLetterController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			'postOnly + delete', // we only allow deletion via POST request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	/* 
	public function actionCreate()
	{
		$model=new HrdTReportDutyLetter;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['HrdTReportDutyLetter']))
		{
			$model->attributes=$_POST['HrdTReportDutyLetter'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->report_duty_letter_id));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}
	*/
	public function actionCreate($id)
	{
		$model=new HrdTReportDutyLetter;
                
                $dutyLetter = HrdMDutyLetter::model()->findByAttributes(array('duty_letter_id'=>$id));
                if($dutyLetter == null){
                    throw new CHttpException(404,'Duty Letter does not exist.');
                    return $dutyLetter;
                }else{
                    $dutyLetterCurrentStatus = $dutyLetter->status_id;
                }
                
                $dutyLetterRequest = HrdTRequestDutyLetter::model()->findByAttributes(array('rdl_id'=>$dutyLetter->request_id));
                if($dutyLetterRequest == null){
                    throw new CHttpException(404,'Duty Letter Request does not exist.');
                    return $dutyLetterRequest;
                }else{
                    $dutyLetterRequestCurrentStatus = $dutyLetterRequest->status_id;
                }
                
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
                
		if(isset($_POST['HrdReportDutyLetter']))
		{
			$model->attributes=$_POST['HrdReportDutyLetter'];
                        $dutyLetter->status_id=Yii::app()->constanta->constStatus['Reported'];
                        $model->duty_letter_id=$dutyLetter->duty_letter_id;
                        
                        if(($dutyLetterRequestCurrentStatus==Yii::app()->constanta->constStatus['Approved'])
                            && $dutyLetterCurrentStatus==Yii::app()->constanta->constStatus['Released']){
                            
                            $model->file_report=CUploadedFile::getInstance($model,'file_report');
                            $model->image->saveAs(Yii::app()->basePath.'/../protected/report/'.$model->report_file->getName());
                            $model->report_date = new CDbExpression('NOW()');
                            $model->report_file_name = 'Report of Duty Letter Number ' . $dutyLetter->duty_letter_number;
                            
                            if($model->save()){
                                if($dutyLetter->save()){
                                    Yii::app()->user->setFlash('save','Report has been uploaded.');
                                    $this->redirect(array('view','id'=>$model->report_duty_letter_id));
                                }
                            }
                        }else{
                            Yii::app()->user->setFlash('error','Duty Letter is no longer available to be reported.');
                            $this->render('errorNotification',array(
                                'dutyLetter'=>$dutyLetter,
                            ));
                        }
                        
//			if($model->save())
//				$this->redirect(array('view','id'=>$model->report_duty_letter_id));
		}
                
                if(($dutyLetterRequestCurrentStatus==Yii::app()->constanta->constStatus['Approved'])
                        && $dutyLetterCurrentStatus==Yii::app()->constanta->constStatus['Released']){
                    $this->render('create',array(
                    'model'=>$model,
                    'dutyLetter'=>$dutyLetter,
                    'dutyLetterRequest'=>$dutyLetterRequest,
                ));
                }
                else{
                    Yii::app()->user->setFlash('error','Report could not be uploaded. Please check duty letter request and duty letter status.');
                    $this->render('errorNotification',array(
                        'dutyLetter'=>$dutyLetter,
                    ));
                }
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['HrdTReportDutyLetter']))
		{
			$model->attributes=$_POST['HrdTReportDutyLetter'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->report_duty_letter_id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('HrdTReportDutyLetter');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new HrdTReportDutyLetter('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['HrdTReportDutyLetter']))
			$model->attributes=$_GET['HrdTReportDutyLetter'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return HrdTReportDutyLetter the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=HrdTReportDutyLetter::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param HrdTReportDutyLetter $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='hrd-treport-duty-letter-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
