<?php

/**
 * This is the model class for table "hrd_d_pegawai".
 *
 * The followings are the available columns in table 'hrd_d_pegawai':
 * @property integer $pegawaidetail_id
 * @property integer $nip
 * @property string $no_ktp
 * @property string $d_akhir_ktp
 * @property string $alamat_ktp
 * @property string $no_hp
 * @property string $no_tlp_rumah
 * @property string $created_by
 * @property string $created_date
 * @property string $created_ip
 * @property string $updated_by
 * @property string $updated_date
 * @property string $updated_ip
 *
 * The followings are the available model relations:
 * @property HrdMPegawai $nip0
 */
class HrdDPegawai extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return HrdDPegawai the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'hrd_d_pegawai';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('pegawaidetail_id, nip', 'numerical', 'integerOnly'=>true),
			array('no_ktp', 'length', 'max'=>45),
			array('alamat_ktp', 'length', 'max'=>255),
			array('no_hp, no_tlp_rumah', 'length', 'max'=>20),
			array('created_by, updated_by', 'length', 'max'=>200),
			array('created_ip, updated_ip', 'length', 'max'=>15),
			array('d_akhir_ktp, created_date, updated_date', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('pegawaidetail_id, nip, no_ktp, d_akhir_ktp, alamat_ktp, no_hp, no_tlp_rumah, created_by, created_date, created_ip, updated_by, updated_date, updated_ip', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'nip0' => array(self::BELONGS_TO, 'HrdMPegawai', 'nip'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'pegawaidetail_id' => 'Pegawaidetail',
			'nip' => 'Nip',
			'no_ktp' => 'No Ktp',
			'd_akhir_ktp' => 'D Akhir Ktp',
			'alamat_ktp' => 'Alamat Ktp',
			'no_hp' => 'No Hp',
			'no_tlp_rumah' => 'No Tlp Rumah',
			'created_by' => 'Created By',
			'created_date' => 'Created Date',
			'created_ip' => 'Created Ip',
			'updated_by' => 'Updated By',
			'updated_date' => 'Updated Date',
			'updated_ip' => 'Updated Ip',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('pegawaidetail_id',$this->pegawaidetail_id);
		$criteria->compare('nip',$this->nip);
		$criteria->compare('no_ktp',$this->no_ktp,true);
		$criteria->compare('d_akhir_ktp',$this->d_akhir_ktp,true);
		$criteria->compare('alamat_ktp',$this->alamat_ktp,true);
		$criteria->compare('no_hp',$this->no_hp,true);
		$criteria->compare('no_tlp_rumah',$this->no_tlp_rumah,true);
		$criteria->compare('created_by',$this->created_by,true);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('created_ip',$this->created_ip,true);
		$criteria->compare('updated_by',$this->updated_by,true);
		$criteria->compare('updated_date',$this->updated_date,true);
		$criteria->compare('updated_ip',$this->updated_ip,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

    protected function beforeSave()
    {
        // convert to storage format
        $this->d_akhir_ktp = DateTime::createFromFormat('m/d/Y', $this->d_akhir_ktp)->format('Y-m-d');

        return parent::beforeSave();
    }

    protected function afterValidate(){
        if ($this->isNewRecord){
            $this->created_date=new CDbExpression('NOW()');
            $this->created_by=Yii::app()->user->getId();
            $this->created_ip=Yii::app()->request->getUserHostAddress();


        }else{
            $this->updated_date=new CDbExpression('NOW()');
            $this->updated_by=Yii::app()->user->getId();
            $this->updated_ip=Yii::app()->request->getUserHostAddress();
        }
    }
}