<?php
/* @var $this UserController */
/* @var $model User */
/* @var $form CActiveForm */
?>

<div class="form">

<?php $form=$this->beginWidget('CActiveForm', array(
	'id'=>'user-form',
	'enableAjaxValidation'=>false,
)); ?>

	<p class="note">Fields with <span class="required">*</span> are required.</p>

	<?php echo $form->errorSummary($model); ?>

	<div class="row">
		<?php echo $form->labelEx($model,'username'); ?>
		<?php if ($model->isNewRecord) { ?>
			<?php echo $form->textField($model,'username',array('size'=>20,'maxlength'=>20)); ?>
		<?php } else {?>
			<?php echo $form->textField($model,'username',array('size'=>20,'maxlength'=>20,'disabled'=>'disabled')); ?>
		<?php } ?>
		<?php echo $form->error($model,'username'); ?>
	</div>

	
	<div class="row">
		<?php echo $form->labelEx($model,'password'); ?>
		<?php echo $form->passwordField($model,'password',array('size'=>50,'maxlength'=>50,'value'=>'')); ?>
		<?php echo $form->error($model,'password'); ?>
	</div>
	
	<div class="row">
		<?php echo $form->labelEx($model,'password_repeat'); ?>
		<?php echo $form->passwordField($model,'password_repeat',array('size'=>50,'maxlength'=>50)); ?>
		<?php echo $form->error($model,'password_repeat'); ?>
	</div>
	
	<div class="row">
		<?php echo $form->labelEx($model,'email'); ?>
		<?php echo $form->textField($model,'email',array('size'=>50,'maxlength'=>50)); ?>
		<?php echo $form->error($model,'email'); ?>
	</div>
	<div class="row">
		<?php echo $form->labelEx($model,'login_type'); ?>
		<?php echo $form->dropDownList($model,'login_type',array(0=>'IMAP',1=>'DB')); ?>
		<?php echo $form->error($model,'login_type'); ?>
	</div>
	<div class="row">
		<?php echo $form->labelEx($model,'status'); ?>
		<?php echo $form->dropDownList($model,'status',array(1=>'AKTIF',0=>'TIDAK AKTIF')); ?>
		<?php echo $form->error($model,'status'); ?>
	</div>
	<?php //if($model->isNewRecord){?>
	<?php if (extension_loaded('gd')): ?> 
        <div class="row"> 
            <?php echo CHtml::activeLabelEx($model, 'verifyCode') ?> 
            <div> 
                <?php $this->widget('CCaptcha'); ?><br/> 
                <?php echo CHtml::activeTextField($model,'verifyCode'); ?> 
            </div> 
            <div class="hint">Ketik tulisan yang ada pada gambar . 
            <br/>Tulisan tidak case sensitive</div> 
        </div> 
    <?php endif; ?>
    <?php// }?>
	<div class="row buttons">
		<?php echo CHtml::submitButton($model->isNewRecord ? 'Create' : 'Save'); ?>
	</div>

<?php $this->endWidget(); ?>

</div><!-- form -->