<?php
/* @var $this ImapController */
/* @var $model Imap */

$this->breadcrumbs=array(
    'Admin'=>array('../rbac/user/admin'),
    'View IMAP Configuration',
);

$this->menu=array(
	
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$('#imap-grid').yiiGridView('update', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage IMAP Configuration</h1>

<p>
You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php $this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'imap-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'columns'=>array(
		'sys_m_imap_host',
		'sys_m_imap_name',
		'sys_m_imap_port',
		'max_tries_to_login',
		'max_bann_time',
		array(
			'class'=>'CButtonColumn','template'=>'{view}{update}'
		),
	),
)); ?>
