<?php

/**
 * This is the model class for table "sys_m_imap".
 *
 * The followings are the available columns in table 'sys_m_imap':
 * @property integer $sys_m_imap_id
 * @property string $sys_m_imap_host
 * @property string $sys_m_imap_name
 * @property string $sys_m_imap_port
 * @property integer $max_tries_to_login
 * @property integer $max_bann_time
 * @property string $created_date
 * @property integer $created_by
 * @property string $created_ip
 * @property string $modified_date
 * @property integer $modified_by
 * @property string $modified_ip
 */
class Imap extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Imap the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'sys_m_imap';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('sys_m_imap_host, sys_m_imap_name, sys_m_imap_port, max_tries_to_login, max_bann_time', 'required'),
			array('max_tries_to_login, max_bann_time, created_by, modified_by', 'numerical', 'integerOnly'=>true),
			array('sys_m_imap_host', 'length', 'max'=>12),
			array('sys_m_imap_name', 'length', 'max'=>25),
			array('sys_m_imap_port', 'length', 'max'=>20),
			array('created_ip, modified_ip', 'length', 'max'=>30),
			array('created_date, modified_date', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('sys_m_imap_id, sys_m_imap_host, sys_m_imap_name, sys_m_imap_port, max_tries_to_login, max_bann_time, created_date, created_by, created_ip, modified_date, modified_by, modified_ip', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}
	protected function afterValidate(){
		if ($this->isNewRecord){
			//$this->posted_date=new CDbExpression('NOW()');
			$this->created_date=new CDbExpression('NOW()');
			$this->created_by=Yii::app()->user->getId();
			//$this->created_by=Yii::app()->constanta->getIdUserLogin();
			$this->created_ip=Yii::app()->request->getUserHostAddress();
	
	
		}else{
			$this->modified_date=new CDbExpression('NOW()');
			//$this->created_by=Yii::app()->constanta->getIdUserLogin();
			$this->modified_by=Yii::app()->user->getId();
			$this->modified_ip=Yii::app()->request->getUserHostAddress();
		}
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'sys_m_imap_id' => 'Sys M Imap',
			'sys_m_imap_host' => 'IP Address IMAP Host',
			'sys_m_imap_name' => 'IMAP Name',
			'sys_m_imap_port' => 'IMAP Port',
			'max_tries_to_login' => 'Max Tries To Login',
			'max_bann_time' => 'Max Bann Time',
			'created_date' => 'Created Date',
			'created_by' => 'Created By',
			'created_ip' => 'Created Ip',
			'modified_date' => 'Modified Date',
			'modified_by' => 'Modified By',
			'modified_ip' => 'Modified Ip',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('sys_m_imap_id',$this->sys_m_imap_id);
		$criteria->compare('sys_m_imap_host',$this->sys_m_imap_host,true);
		$criteria->compare('sys_m_imap_name',$this->sys_m_imap_name,true);
		$criteria->compare('sys_m_imap_port',$this->sys_m_imap_port,true);
		$criteria->compare('max_tries_to_login',$this->max_tries_to_login);
		$criteria->compare('max_bann_time',$this->max_bann_time);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_ip',$this->created_ip,true);
		$criteria->compare('modified_date',$this->modified_date,true);
		$criteria->compare('modified_by',$this->modified_by);
		$criteria->compare('modified_ip',$this->modified_ip,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}