<?php

/**
 * This is the model class for table "sys_m_controller".
 *
 * The followings are the available columns in table 'sys_m_controller':
 * @property string $sys_m_controller_id
 * @property string $sys_m_module_id
 * @property string $desc
 *
 * The followings are the available model relations:
 * @property SysMModule $sysMModule
 */
class AppController extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return AppController the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'sys_m_controller';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('sys_m_controller_id, sys_m_module_id', 'required'),
			array('sys_m_controller_id, sys_m_module_id', 'length', 'max'=>100),
			array('sys_m_controller_id', 'unique','message'=>'This controller id already exists.'),
			array('desc', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('sys_m_controller_id, sys_m_module_id, desc,dcrea, ucrea, uupd, dupd, icrea, iupd', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'sysMModule' => array(self::BELONGS_TO, 'SysMModule', 'sys_m_module_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'sys_m_controller_id' => 'Sys M Controller',
			'sys_m_module_id' => 'Sys M Module',
			'desc' => 'Desc',
			'dcrea' => 'Created Date ',
			'ucrea' => 'Created by',
			'uupd' => 'Updated by',
			'dupd' => 'Updated Date ',
			'icrea' => 'Created IP ',
			'iupd' => 'Updated IP ',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('sys_m_controller_id',$this->sys_m_controller_id,true);
		$criteria->compare('sys_m_module_id',$this->sys_m_module_id,true);
		$criteria->compare('desc',$this->desc,true);
		$criteria->compare('dcrea',$this->dcrea,true);
		$criteria->compare('ucrea',$this->ucrea,true);
		$criteria->compare('uupd',$this->uupd,true);
		$criteria->compare('dupd',$this->dupd,true);
		$criteria->compare('icrea',$this->icrea,true);
		$criteria->compare('iupd',$this->iupd,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	public function afterValidate(){
		parent::afterValidate();
			if ($this->isNewRecord){
                $this->dcrea=new CDbExpression('NOW()');
                $this->ucrea=Yii::app()->user->getName();
            }else{
                $this->dupd=new CDbExpression('NOW()');
                $this->uupd=Yii::app()->user->getName();
            }       

    }
	public function getControllerByModulId($sys_m_module_id) {  
            if(empty($sys_m_module_id))  
                $sys_m_module_id = Null;  
            $criteria = new CDbCriteria;
            $criteria->condition = "sys_m_module_id='$sys_m_module_id'";   
            $data = AppController::model()->findAll($criteria,array('sys_m_module_id'=>$sys_m_module_id));   
            //$Id=AppController::model()->findBySql('SELECT app_controller_id FROM app_controller ORDER BY app_controller_id DESC LIMIT 1');
            $semArr = CHtml::listData($data, 'sys_m_controller_id', 'sys_m_controller_id');
            
            return $semArr;  
    }
}