<?php
class EAutoGrowTextArea extends CInputWidget {

	/**
	 * The maximum height of the component. Default to 500.
	 * @var int
	 */
	public $maxHeight=1000;
	/**
	 * The minimum height of the component. Default to 50.
	 * @var int
	 */
	public $minHeight=100;
	/**
	 * The line height for changes. Default to 16.
	 * @var int
	 */
	public $lineHeight=16;

	public function run(){

		list($name, $id) = $this->resolveNameID();

		$dir = dirname(__FILE__).DIRECTORY_SEPARATOR.'jquery';
		$baseUrl = Yii::app()->getAssetManager()->publish($dir);

		$cs = Yii::app()->getClientScript();
		$cs->registerCoreScript('jquery');
		$cs->registerScriptFile($baseUrl.'/jquery.autogrow.js');

		if ($this->hasModel()){
			$html = CHtml::activeTextArea($this->model, $this->attribute, $this->htmlOptions);
		}else{
			$html = CHtml::textArea($id, $this->value, $this->htmlOptions);
		}

		$js = $this->jsCode($id);
		$cs->registerScript(get_class($this).'_'.$id, $js);
		echo $html;
	}

	protected function jsCode($id)
	{
		$js =<<<EOP
		$("#{$id}").autogrow({
			maxHeight: {$this->maxHeight},
			minHeight: {$this->minHeight},
			lineHeight: {$this->lineHeight}
		});
EOP;

		return $js;
	}
}
?>