function Ye = extract_function (U1,V1,Y) 
%----------------------------------------------------------------------------------------------%
%Fungsi DCT 
DCTE = dct(Y); 
B = zeros(4 , 4); 
temp = 1;
for i = 1 : 4
    for j = 1 : 4
        B(i,j) = DCTE(1, temp);
        temp = temp + 1;           
    end    
end    

%----------------------------------------------------------------------------------------------%
%Fungsi SVD
[Ue,Se,Ve] = svd(B);
Ue1 = reshape(U1', [4 4]);
Ve1 = reshape(V1', [4 4]);


%----------------------------------------------------------------------------------------------%
%Ekstrak Watermark
alpha = 0.00001;
DW = Ue1 * Se * Ve1';
We = DW / alpha;
GambarE = [];
temp = 1;
for i = 1 : 4
    for j = 1 : 4
        if j ~= i 
            GambarE(temp) = We(i,j);
            temp = temp + 1;         
        end
    end
end

GambarE = abs(GambarE);

Ye = [];
for i = 1 : 12 
    if GambarE(i) < 0.5
        Ye(i) = 0 ;
    else
        Ye(i) = 1 ;
    end
end
