function [U1,Y,V1] = embeed_function(voice_frame, Gambar) 
%----------------------------------------------------------------------------------------------%
%Fungsi DCT 
DCT = dct(voice_frame); 

A = zeros(4,4);

temp = 1;
for i = 1 : 4
    for j = 1 : 4
        A(i,j) = DCT(1, temp);
        temp = temp + 1;           
    end     
end    


%----------------------------------------------------------------------------------------------%
%Fungsi SVD
[U,S,V] = svd(A);


%----------------------------------------------------------------------------------------------%
%Embeed Watermark
B = Gambar;
index_b = 1;
W = zeros(4,4);
for i = 1 : 4
    for j = 1 : 4                   
        if i ~= j
            W(i,j) = B (index_b);
            index_b = index_b + 1;
        end
    end
end

%Pemberian nilai alpha
alpha = 0.0001;
Sn = S + W * alpha;           % hasil Embeed
[U1,S,V1] = svd(Sn);          %SVD Sn U1 dan V1 akan digunakan pada proses ektraksi


%----------------------------------------------------------------------------------------------%

%Invers SVD
invers_Sn = U * Sn * V' ;
%mengubah ke matkis 1 x 16 sebelum di invers dct
Y = [];
temp = 1;
for i = 1 : 4
    for j = 1 : 4
        Y(temp) = invers_Sn(i,j);
        temp = temp + 1;
    end
end    

%----------------------------------------------------------------------------------------------%
%Invers DCT
invers_dct_Sn = idct(invers_Sn);
Y = idct(Y);

