function varargout = Extraction(varargin)
% EXTRACTION MATLAB code for Extraction.fig
%      EXTRACTION, by itself, creates a new EXTRACTION or raises the existing
%      singleton*.
%
%      H = EXTRACTION returns the handle to a new EXTRACTION or the handle to
%      the existing singleton*.
%
%      EXTRACTION('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in EXTRACTION.M with the given input arguments.
%
%      EXTRACTION('Property','Value',...) creates a new EXTRACTION or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Extraction_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Extraction_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help Extraction

% Last Modified by GUIDE v2.5 09-Jun-2021 11:08:15

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Extraction_OpeningFcn, ...
                   'gui_OutputFcn',  @Extraction_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before Extraction is made visible.
function Extraction_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Extraction (see VARARGIN)

% Choose default command line output for Extraction
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes Extraction wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = Extraction_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;

%----------------------------------------------------------------------------------------------%
% Browse audio berwatermark
function Browse_Audiowatermark(hObject, eventdata, handles)
%persiapan file audio
[filename, pathname] = uigetfile({'*.wav'});
fullpathname = fullfile (pathname, filename);
[X, Fs] = audioread(fullpathname);  %Fs adalah sampling

%check apakah user menekan cancel pada dialog
if isequal(filename,0) || isequal(pathname,0)
uiwait(msgbox ('User menekan Cancel','failed','modal') )
hold on;
else
uiwait(msgbox('Audio sudah dipilih','sucess','modal'));
hold off;
        X = X (:,1)
        N = length(X);
        t = (0:N-1)/Fs; 

         %plot
         axes(handles.axes1);
         plot(t,X)
         grid on
         xlabel('Time (s)')
         ylabel('Amplitudo')
end
handles.output = hObject;
handles.fullpathname = fullpathname;
handles.Fs = Fs;
handles.X = X;
guidata(hObject, handles);
%----------------------------------------------------------------------------------------------%

%------------------------------------------Fungsi Ekstraksi------------------------------------------------------------------------------------------%

function pushbutton2_Callback(hObject, eventdata, handles)
%Membagi matriks x ke dalam frame
if isfield(handles, 'fullpathname')
koresponden_Un1 = csvread('koresponden_Un1.csv');
koresponden_Vn1 = csvread('koresponden_Vn1.csv');
koresponden_Un2 = csvread('koresponden_Un2.csv');
koresponden_Vn2 = csvread('koresponden_Vn2.csv');

X = handles.X;
frame_size = 32; % jumlah sample per frames
temp = 0;
for i = 1 : length(X)/32
   frames(i, 1:32) = X(temp + 1 : temp + frame_size);
   temp = temp + frame_size;
end
%----------------------------------------------------------------------------------------------%

wintype = 'hamming';
winlen = 32;
winamp = [0.5,1]*(1/winlen);

%----------------------------------------------------------------------------------------------%
%Menghitung nilai STE perframe
temp = 0;
[a, b] = size(frames);
for i = 1 : a
   energy_frames(i,:) = energy(frames(i,:),wintype,winamp(2),winlen);
   temp = temp + frame_size;   
end
ste = sum(energy_frames.');
ste = ste';
%----------------------------------------------------------------------------------------------%
%Menghitung nilai ZCC perframe
temp = 0;
for i = 1 : a
   zcc_frames(i,:) = zerocross(frames(i,:),wintype,winamp(1),winlen);
   temp = temp + frame_size;   
end
zc = sum(zcc_frames.');
zc = zc';

%----------------------------------------------------------------------------------------------%
%Memisahkan Frame bersuara dengan Tidak Bersuara
ste_batas = max(ste)/8;             %Tracehold ditentukan
zcc_batas = max(zc)/2;              %Tracehold ditentukan
temp1 = 1;
temp2 = 1;
ste_index2 = [];                     %memberikan index frame bersuara tidak bersuara
voice_frame = [];                   %kumpulan frame bersuara
unvoice_frame = [];                 %kumpulan frame tidak bersuara
for i = 1 : length(ste)
    if ste(i) >= ste_batas
        if zc(i) <= zcc_batas            
            ste_index2 (i,1) = 1;          
            voice_frame(temp1,:) = frames(i,:);
            temp1 = temp1 + 1;          
        else
            ste_index2(i,1) = 0;
            unvoice_frame(temp2, :) = frames(i,:);
            temp2 = temp2 + 1;
        end
    else
        ste_index2(i,1) = 0;
        unvoice_frame(temp2, :) = frames(i,:);
        temp2 = temp2 + 1;        
    end    
end

%----------------------------------------------------------------------------------------------%
%Ekstrak watermark dari file audio
watermark1 = [];
watermark2 = [];
for i = 1 : length(koresponden_Un1)
        x = voice_frame(i,1:16);
        y = koresponden_Un1(i,1:16);
        z = koresponden_Vn1(i,1:16);

%----------------------------------------------------------------------------------------------%
%mengoleksi hasil extract
        B = extract_function(y,z,x);  %fungsi ekstrak Watermark Bit
        watermark1(i,:) = B;
        
        x = voice_frame(i,17:32);        
        y = koresponden_Un2(i,1:16);
        z = koresponden_Vn2(i,1:16);
        
%----------------------------------------------------------------------------------------------%
%mengoleksi hasil extract
        B = extract_function(y,z,x);  %fungsi ekstrak Watermark Bit
        watermark2(i,:) = B;
end

%----------------------------------------------------------------------------------------------%
%Hasil ekstrak
ekstrak1 = reshape(watermark1', 24,[]);
for i = 1 : size(ekstrak1, 1)
    for j = 1 : size(ekstrak1, 2)
        if ekstrak1(i,j) == 0
           ekstrak1(i,j) = -255;
        else
           ekstrak1 (i,j)  = 255; 
        end
    end
end

ekstrak2 = reshape(watermark2', 24,[]);
for i = 1 : size(ekstrak2, 1)
    for j = 1 : size(ekstrak2, 2)
        if ekstrak2(i,j) == 0
           ekstrak2(i,j) = -255;
        else
           ekstrak2 (i,j)  = 255; 
        end
    end
end


%----------------------------------------------------------------------------------------------%
%Hasil ekstrak watermark 1
imwrite(ekstrak1, 'Watermark_hasil_ekstrak1.png');

handles.output = hObject;
handles.ekstrak1 = ekstrak1;
guidata(hObject, handles);
axes(handles.axes2);
imshow(ekstrak1);
%----------------------------------------------------------------------------------------------%
%Hasil ekstrak watermark 2
imwrite(ekstrak2, 'Watermark_hasil_ekstrak2.png');

handles.output = hObject;
handles.ekstrak2 = ekstrak2;
guidata(hObject, handles);
axes(handles.axes3);
imshow(ekstrak2);
%----------------------------------------------------------------------------------------------%

end
%----------------------------------------------------------------------------------------------%

%----------------------------------------------------------------------------------------------%
function pushbutton3_Callback(hObject, eventdata, handles)
%Fungsi Menyimpan Watermark1 hasil ekstraksi
[filename, pathname] = uiputfile('*.png');
Name = fullfile(pathname, filename);
hChildAxes2 = get(handles.axes2, 'Children');
W = get(hChildAxes2(1), 'CData');
imwrite(W, Name, 'png');

%----------------------------------------------------------------------------------------------%
function pushbutton4_Callback(hObject, eventdata, handles)
%Fungsi Menyimpan Watermark2 hasil ekstraksi
[filename, pathname] = uiputfile('*.png');
Name = fullfile(pathname, filename);
hChildAxes3 = get(handles.axes3, 'Children');
Z = get(hChildAxes3(1), 'CData');
imwrite(Z, Name, 'png');
%----------------------------------------------------------------------------------------------%
