Guía Definitiva de Yii 2.0
==========================

Este tutorial se publica con arreglo a los [Términos de Documentación Yii](http://www.yiiframework.com/doc/terms/).

Todos los derechos reservados.

2014 (c) Yii Software LLC.


Introducción
------------

* [Acerca de Yii](intro-yii.md)
* [Actualizar desde Yii 1.1](intro-upgrade-from-v1.md)


Primeros pasos
--------------

* [Instalar Yii](start-installation.md)
* [Funcionamiento de aplicaciones](start-workflow.md)
* [Hola a todos](start-hello.md)
* [Trabajar con formularios](start-forms.md)
* [Trabajar con bases de datos](start-databases.md)
* [Generar códigos con Gii](start-gii.md)
* [Adentrarse en Yii](start-looking-head.md)


Estructura de una aplicación
----------------------------

* [Información general](structure-overview.md)
* [Script de entrada](structure-entry-scripts.md)
* [Aplicaciones](structure-applications.md)
* [Componentes de una aplicación](structure-application-components.md)
* [Controladores](structure-controllers.md)
* [Modelos](structure-models.md)
* [Vistas](structure-views.md)
* **TBD** [Filtros](structure-filters.md)
* **TBD** [Widgets](structure-widgets.md)
* **TBD** [Módulos](structure-modules.md)
* [Recursos](structure-assets.md)
* **TBD** [Extensiones](structure-extensions.md)


Gestión de las peticiones
-------------------------

* **TBD** [Bootstrapping](runtime-bootstrapping.md)
* **TBD** [Rutas](runtime-routing.md)
* **TBD** [Peticiones](runtime-requests.md)
* **TBD** [Respuestas](runtime-responses.md)
* **TBD** [Sesiones y Cookies](runtime-sessions-cookies.md)
* [Procesamiento y generación de las URL](runtime-url-handling.md)
* [Gestión de errores](runtime-handling-errors.md)
* [Registro de anotaciones](runtime-logging.md)


Conceptos clave
---------------

* [Componentes](concept-components.md)
* [Propiedades](concept-properties.md)
* [Eventos](concept-events.md)
* [Comportamientos (Behaviors)](concept-behaviors.md)
* [Configuraciones](concept-configurations.md)
* [Alias](concept-aliases.md)
* [Autocarga de clases](concept-autoloading.md)
* [Localizador de servicios (Service Locator)](concept-service-locator.md)
* [Contenedor de inyección de dependencia](concept-di-container.md)


Trabajar con bases de datos
-----------------------------

* [Objeto de acceso a datos](db-dao.md) - Conexión a una base de datos, consultas básicas, transacciones y manipulación de esquemas
* [Constructor de consultas](db-query-builder.md) - Consulta de la base de datos utilizando una simple capa de abstracción
* [Active Record](db-active-record.md) - ORM Active Record, recuperación y manipulación de registros y definición de relaciones
* [Migraciones](db-migrations.md) - Control de versiones de bases de datos en el entorno de desarrollo en equipo
* **TBD** [Sphinx](db-sphinx.md)
* **TBD** [Redis](db-redis.md)
* **TBD** [MongoDB](db-mongodb.md)
* **TBD** [ElasticSearch](db-elastic-search.md)


Obtener datos de los usuarios
-----------------------------

* [Crear formularios](input-forms.md)
* [Validar datos](input-validation.md)
* **TBD** [Subir archivos](input-file-upload.md)
* **TBD** [Obtener datos para múltiples modelos](input-multiple-models.md)


Visualizar datos
----------------

* **TBD** [Formato de datos](output-formatting.md)
* **TBD** [Paginación](output-pagination.md)
* **TBD** [Ordenación](output-sorting.md)
* [Proveedores de datos](output-data-providers.md)
* [Widgets de datos](output-data-widgets.md)
* [Utilización de temas](output-theming.md)


Seguridad
---------

* [Autenticación](security-authentication.md)
* [Autorización](security-authorization.md)
* [Trabajar con contraseñas](security-passwords.md)
* **TBD** [Auth Clients](security-auth-clients.md)
* **TBD** [Buenas prácticas](security-best-practices.md)


Caché
-----

* [Información general](caching-overview.md)
* [Caché de datos](caching-data.md)
* [Caché de fragmentos](caching-fragment.md)
* [Caché de páginas](caching-page.md)
* [Caché HTTP](caching-http.md)


Servicios Web RESTful 
---------------------

* [Guía breve](rest-quick-start.md)
* [Recursos (Resources)](rest-resources.md)
* [Controladores](rest-controllers.md)
* [Gestión de rutas](rest-routing.md)
* [Formateo de respuestas](rest-response-formatting.md)
* [Autenticación](rest-authentication.md)
* [Límite de Rango](rest-rate-limiting.md)
* [Gestión de versiones](rest-versioning.md)
* [Gestión de errores](rest-error-handling.md)


Herramientas de Desarrollo
--------------------------

* [Depurador y Barra de Herramientas de Depuración](tool-debugger.md)
* [Generación de códigos con Gii](tool-gii.md)
* **TBD** [Generación de documentación de API](tool-api-doc.md)


Pruebas
------

* [Información general](test-overview.md)
* **TBD** [Pruebas unitarias](test-unit.md)
* **TBD** [Pruebas funcionales](test-functional.md)
* **TBD** [Pruebas de aceptación](test-acceptance.md)
* [Fixtures](test-fixtures.md)


Extender Yii
------------

* [Crear extensiones](extend-creating-extensions.md)
* [Personalizar el código de base](extend-customizing-core.md)
* [Utilizar librerías de terceros](extend-using-libs.md)
* **TBD** [Utilizar Yii en sistemas de terceros](extend-embedding-in-others.md)
* **TBD** [Utilizar las versiones 1.1 y 2.0 de Yii juntas](extend-using-v1-v2.md)
* [Utilizar Composer](extend-using-composer.md)


Temas especiales
----------------

* [Plantilla aplicación avanzada](tutorial-advanced-app.md)
* [Creación de una aplicación desde cero](tutorial-start-from-scratch.md)
* [Comandos de consola](tutorial-console.md)
* [Validadores de base](tutorial-core-validators.md)
* [Internacionalización](tutorial-i18n.md)
* [Envío de correos electrónicos](tutorial-mailing.md)
* [Mejora del rendimiento](tutorial-performance-tuning.md)
* **TBD** [Entorno de alojamiento compartido](tutorial-shared-hosting.md)
* [Motores de plantillas](tutorial-template-engines.md)


Widgets
-------

* GridView: link to demo page
* ListView: link to demo page
* DetailView: link to demo page
* ActiveForm: link to demo page
* Pjax: link to demo page
* Menu: link to demo page
* LinkPager: link to demo page
* LinkSorter: link to demo page
* [Bootstrap Widgets](bootstrap-widgets.md)
* **TBD** [Jquery UI Widgets](jui-widgets.md)


Clases auxiliares
-----------------

* [Información general](helper-overview.md)
* **TBD** [ArrayHelper](helper-array.md)
* **TBD** [Html](helper-html.md)
* **TBD** [Url](helper-url.md)
* **TBD** [Security](helper-security.md)

