Как работать над переводом на русский
=====================================

Yii переводится на множество языков, в том числе и на русский. Перевод включает в себя документацию и сообщения.

Сообщения фреймворка
--------------------

Есть два типа сообщений: исключения, которые нацелены на разработчиков и не переводятся и сообщения, которые показваются
пользователям. Например, ошибки валидации.

Для того, чтобы обновить перевод:

1. Открываем в консоли директорию `framework`, запускаем `yii message/extract messages/config.php`.
3. Переводим сообщения в `framework/messages/ru/yii.php`. Важно чтобы файлы были в кодировке UTF-8.
4. [Делаем pull request](https://github.com/yiisoft/yii2/blob/master/docs/internals/git-workflow.md) с переводом из `ru`,
остальные языки не трогаем.

В файле перевода находится массив. Его ключи — исходные строки, значения — перевод. Если значение пусто, сообщение
считается не переведённым. Переводы сообщений, которые больше не встречаются в коде, обрамлены `@@`. Для некоторых сообщений
необходимо использовать [специальный формат для поддержки употребления с числительными](../guide/i18n.md).

Документация
------------

Перевод документации находится в `docs/<original>-ru`, где `<original>` соответствует оригинальной директории, например
`guide` или `internals`.

Если перевод документа завершён, можно получить diff изменений в оригинале со времени последнего перевода, открыв консоль
в директории `build` и выполнив:

```
build translation ../docs/guide" "../docs/guide-ru" --title="Russian guide translation report" > report-guide-ru.html
```

Все изменения оформляем в виде [pull request](https://github.com/yiisoft/yii2/blob/master/docs/internals/git-workflow.md).

[Список всех переводимых документов](https://docs.google.com/spreadsheets/d/1uxV0LwmR-8XXqlT8C6VqWllZjuoyIj-UkYpAQPWyUzE/edit?usp=sharing)
доступен для редактирования на Google Docs.