Обработка ошибок
================

> Раздел в разработке.

Обработка ошибок в Yii происходит несколько иначе, чем в обычном PHP. Во-первых, все нефатальные ошибки в Yii преобразуются в *исключения*:

```php
use yii\base\ErrorException;
use Yii;

try {
    10/0;
} catch (ErrorException $e) {
    Yii::warning("Попытка деления на ноль.");
}

// можно продолжать выполнение
```

Как это видно из примера, вы можете обрабатывать ошибки, используя конструкцию `try`-`catch`.

Во-вторых, даже фатальные ошибки в Yii показываются в красивом виде. Это значит, что при отладке кода, вы можете отслеживать причины фатальных 
ошибок. Это позволяет быстрее находить причины возникших проблем.

Рендеринг ошибок в произвольном действии контроллера
----------------------------------------------------

Обычная страница вывода ошибок Yii не только хороша в разработке, но и приемлема для уже развернутых проектов, если `YII_DEBUG` выключена в начальном загрузочном скрипте `index.php`. Но иногда хочется изменить внешний вид страницы с ошибками, чтобы лучше приспособить ее под свой проект.

Самый легкий способ создать свою страницу для отображения ошибок - использовать свое действие (action) для рендеринга сообщений об ошибке. 
Сначала нужно дать приложению понять, что вы хотите использовать свое действие для обработки ошибок. Для этого нужно сконфигурировать компонент `errorHandler` в конфигурационном файле приложения:

```php
// ...
'components' => [
    // ...
    'errorHandler' => [
        'errorAction' => 'site/error',
    ],
]
```
С вышеуказанной конфигурацией, если происходит ошибка, Yii запустит действие `error` контроллера `site`. Это действие запрашивает у компонента `errorHandler`, было ли выброшено исключение, и, если да, отображает соответствующий вид, передавая ему объект исключения в качестве параметра.

```php
public function actionError()
{
    $exception = \Yii::$app->errorHandler->exception;
    if ($exception !== null) {
        return $this->render('error', ['exception' => $exception]);
    }
}
```

После создания `action` нужно создать соответствующий вид, который и будет отображать информацию об исключении. Объект исключения, передаваемый в вид, имеет 
 следующие свойства:

- `statusCode`: HTTP статус (например, 403, 500). Доступен только для [[yii\web\HttpException|HTTP exceptions]].
- `code`: код исключения.
- `message`: сообщение об ошибке.
- `file`: имя файла PHP скрипта, в котором произошла ошибка.
- `line`: номер строки в коде, где произошла ошибка.
- `trace`: стэк вызовов, приведших к ошибке.

Рендеринг ошибок без создания отдельного действия
-------------------------------------------------

Вместо создания отдельного действия внутри контроллера Site, вы можете просто указать Yii какой класс использовать для обработки ошибок:

```php
public function actions()
{
    return [
        'error' => [
            'class' => 'yii\web\ErrorAction',
        ],
    ];
}
```

После задания вышеуказанной связки ошибки с классом обработчиком, создайте вид `views/site/error.php`, который будет использоваться автоматически. 
Виду передаются три параметра:

- `$name`: название ошибки
- `$message`: сообщение об ошибке
- `$exception`: обрабатываемое исключение

Объект `$exception` имеет те же свойства, которые были указаны ранее.
