Оновлення із версії 1.1
=======================

Між версіями 1.1 і 2.0 існує багато відмінностей, так як Yii був повністю переписаний для версії 2.0.
Таким чином, оновлення з версії 1.1 не є таким же тривіальним, як оновлення між мінорними версіями.
У цьому посібнику з оновлення наведено основні відмінності між двома версіями.

Якщо раніше ви не використовували Yii 1.1, ви можете пропустити цей розділ і перейти до розділу
"[Встановлення Yii](start-installation.md)".

Також врахуйте, що Yii 2.0 включає більше нового функціоналу, ніж той, що буде описано тут. Наполегливо рекомендується,
що ви прочитаєте весь посібник, щоб дізнатися який функціонал було додано. Можливо, що необхідний функціонал,
який ви до цього розробляли самі, тепер є частиною фреймворка.


Встановлення
------------

Yii 2.0 повністю заснований на [Composer](https://getcomposer.org/), який де факто є менеджером залежностей для PHP.
Установка фреймворка, також як і розширень, здійснюється через Composer. Більш детальні відомості по встановленню Yii 2.0
приведені в розділі [Встановлення Yii](start-installation.md). Відомості про те, як створювати розширення для Yii 2.0
або адаптувати вже наявні розширення для версії 1.1 під версію 2.0, наведені в розділі
[Створення розширень](extend-creating-extensions.md).


Вимоги PHP
----------

Yii 2.0 використовує PHP 5.4 або вище, який включає велику кількість поліпшень в порівнянні з версією 5.2,
яка використовувалася Yii 1.1. Таким чином, існує багато відмінностей у мові, які ви повинні приймати до уваги.
Нижче наведені основні зміни в PHP:

- [Простори імен](http://php.net/manual/en/language.namespaces.php);
- [Анонімні функції](http://php.net/manual/en/functions.anonymous.php);
- Використання короткого синтаксису для масивів: `[...елементи...]` замість `array(...елементи...)`;
- Використання тегів `<?=` для вивода у файлах представлень.
  З версії PHP 5.4 дану можливість можна використовувати без побоювань;
- [Класи та інтерфейси SPL](http://php.net/manual/en/book.spl.php);
- [Пізнє статичне звʼязування (LSB)](http://php.net/manual/en/language.oop5.late-static-bindings.php);
- [Класи для дати та часу](http://php.net/manual/en/book.datetime.php);
- [Трейти](http://php.net/manual/en/language.oop5.traits.php);
- [Інтернаціонализація (Intl)](http://php.net/manual/en/book.intl.php); Yii 2.0 використовує розширення PHP `intl`
  для різного функціоналу інтернаціоналізації.


Простори імен
-------------

Одним з основних змін в Yii 2.0 є використання просторів імен. Майже кожен клас фреймворку знаходиться у просторі імен,
наприклад, `yii\web\Request`. Префікс "С" більше не використовується в іменах класів. Угода іменування відповідає
структурі каталога, в якій розташовується клас. Наприклад, `yii\web\Request` означає, що відповідний клас знаходиться
у файлі `web/Request.php` в каталогу Yii фреймворка. (Завдяки завантажувачу класів Yii, ви можете використовувати
будь-який клас фреймворку без необхідності безпосередньо підключати його).


Компонент та Обʼєкт
-------------------

В Yii 2.0 клас `CComponent` із версії 1.1 був розділений на два класи: [[yii\base\Object]] і [[yii\base\Component]].
Клас [[yii\base\Object|Object]] є простим базовим класом, який дозволяє використовувати
[геттери та сеттери](concept-properties.md) для властивостей. Клас [[yii\base\Component|Component]] наслідується
від класа [[yii\base\Object|Object]] та підтримує [події](concept-events.md) та [поведінки](concept-behaviors.md).

Якщо вашому класу не потрібно використовувати функціонал подій та поведінок, ви можете використати
[[yii\base\Object|Object]] у якості базового класу. В основному, це випадки, коли класи представляють собою базові
структури даних.


Конфігурація обʼєкта
--------------------

Клас [[yii\base\Object|Object]] надає єдиний спосіб конфігурування обʼєктів. Будь-який дочірній клас
[[yii\base\Object|Object]] може визначити конструктор (якщо потрібно) для своєї конфігурації наступним чином:

```php
class MyClass extends \yii\base\Object
{
    public function __construct($param1, $param2, $config = [])
    {
        // ... ініціализація до того, як буде застосована конфігурація

        parent::__construct($config);
    }

    public function init()
    {
        parent::init();

        // ... ініціализація після того, як була застосована конфігурація
    }
}
```

У прикладі вище, останній параметр конструктора повинен бути масивом конфігурації, який містить пари у форматі
ключ-значення для ініціалізації властивостей обʼєкта. Ви можете перевизначити метод [[yii\base\Object::init()|init()]]
для ініціалізації обʼєкту після того, як до нього була застосована конфігурація.

Слідуючи цій угоді, ви зможете створювати і конфігурувати нові обʼєкти за допомогою масиву конфігурації:

```php
$object = Yii::createObject([
    'class' => 'MyClass',
    'property1' => 'abc',
    'property2' => 'cde',
], [$param1, $param2]);
```

Більш детальна інформація про конфігурацію представлена у розділі [Конфігурації обʼєктів](concept-configurations.md).


Події
-----

В Yii1, події створювалися за допомогою оголошення методу `on` (наприклад, `onBeforeSave`).
В Yii2 ви можете тепер використовувати будь-яке імʼя події. Ви ініціюєте подію за допомогою виклику методу
[[yii\base\Component::trigger()|trigger()]].

```php
$event = new \yii\base\Event;
$component->trigger($eventName, $event);
```

Для прикріплення обробника події використовуйте метод [[yii\base\Component::on()|on()]].

```php
$component->on($eventName, $handler);
// To detach the handler, use:
// $component->off($eventName, $handler);
```

Є також і інші покращення у функціоналі подій. Більш детальна інформація про конфігурація представлена у розділі
[Події](concept-events.md).


Псевдоніми шляху
----------------

Yii 2.0 розширює спосіб використання псевдонімів шляху як для файлів і каталогів, так і для URL.
У Yii 2.0 тепер також потрібно, щоб імʼя псевдоніма починалося із символу `@`, для розмежування псевдонімів від
звичайних шляхів файлів/каталогів і URL. Наприклад, псевдонім `@yii` відповідає каталогу встановлення Yii.
Псевдоніми шляху використовуються в багатьох місцях коду Yii. Наприклад, [[yii\caching\FileCache::cachePath]]
може використовувати як псевдонім шляху, так і звичайний шлях до каталогу.

Псевдоніми шляху тісно повʼязані з простором імен класів. Рекомендується, що ви визначите псевдонім шляху
для кожного базового простору імен, таким чином завантажувач класів Yii може використовуватися без будь-якої
додаткової конфігурації. Наприклад, `@yii` відповідає каталогу встановлення Yii, тому клас `yii\webRequest`
може бути завантажений. Якщо ви використовуєте сторонні бібліотеки, такі як Zend Framework, ви можете також визначити
псевдонім шляху `@Zend`, який відповідає каталогу встановлення фреймворка. Одного разу зробивши це - Yii буде
здатний автоматично завантажувати будь-який клас Zend Framework.

Більш детальна інформація про конфігурації представлена у розділі [Псевдоніми шляху](concept-aliases.md).


Представлення
-------------

Однією із основних змін в Yii2 є те, що спеціальна змінна `$this` у представленні більше не відповідає
поточному контролеру або віджету. Замість цього, `$this` тепер відповідає обʼєкту *представлення*, нової можливості,
яка була введена у версії 2.0. Обʼєкт представлення має тип [[yii\web\View]], який являє собою частину *представлення*
у шаблоні проектування MVC. Якщо ви хочете отримати доступ до контролера або віджету, то використовуйте вираз `$this->context`.

Для рендеринга часткових представлень тепер використовується метод `$this->render()`, а не `$this->renderPartial()`.
Результат виклику методу `render` тепер повинен бути виведений безпосередньо, так як `render` повертає результат
рендеринга, а не відображає його одразу. Наприклад,

```php
echo $this->render('_item', ['item' => $item]);
```

Крім використання PHP у якості основного шаблонізатору, Yii 2.0 також включає офіційні розширення для основних
популярних шаблонізаторів: Smarty і Twig. Шаблонізатор Prado більше не підтримується. Для використання вказаних
шаблонізаторів вам необхідно налаштувати компонент додатка `view` за допомогою вказівки властивостей
[[yii\base\View::$renderers|View::$renderers]].

Більш детальна інформація представлена у розділі [Шаблонізатори](tutorial-template-engines.md).


Моделі
------

Yii 2.0 використовує основний клас [[yii\base\Model]] для моделей, аналогічний класу `CModel` у версії 1.1.
Клас `CFormModel` більше не підтримується. Замість цього, для створення моделі форми у Yii 2.0 ви повинні
безпосередньо успадковуватися від класу [[yii\base\Model]].

У Yii 2.0 зʼявився новий метод [[yii\base\Model::scenarios()|scenarios()]] для оголошення сценаріїв, які підтримуються,
і для позначення в якому сценарії атрибути повинні перевірятися, вважатися безпечними і т. п. Наприклад,

```php
public function scenarios()
{
    return [
        'backend' => ['email', 'role'],
        'frontend' => ['email', '!role'],
    ];
}
```

У прикладі вище, оголошено два сценарії: `backend` і `frontend`. Для сценарію `backend` обидва атрибута `email` і `role`
є безпечними і можуть бути масово привласнені. Для сценарію `frontend` атрибут `email` може бути масово присвоєний,
а атрибут `role` - ні. Обидва атрибути `email` та `role` повинні бути перевірені за допомогою правил валідації.

Метод [[yii\base\Model::rules()|rules()]] як і раніше використовується для оголошення правил валідації.
Зверніть увагу, що у звʼязку з появою нового методу [[yii\base\Model::scenarios()|scenarios()]] -
більше не підтримується валідатор `unsafe`.

У більшості випадків вам не потрібно перевизначати метод [[yii\base\Model::scenarios()|scenarios()]],
якщо метод [[yii\base\Model::rules()|rules()]] повністю вказує всі існуючі сценарії і якщо немає потреби
в оголошенні атрибутів небезпечними.

Більш детальна інформація представлена у розділі [Моделі](structure-models.md).


Контролери
----------

В якості базового класу для контролерів в Yii 2.0 використовується [[yii\web\Controller]],
аналогічний `CWebController` у Yii 1.1. Базовим класом для всіх дій є [[yii\base\Action]].

Однією із основних змін є те, що дія контролера тепер має повернути результат замість того, щоб напряму виводити його:


```php
public function actionView($id)
{
    $model = \app\models\Post::findOne($id);
    if ($model) {
        return $this->render('view', ['model' => $model]);
    } else {
        throw new \yii\web\NotFoundHttpException;
    }
}
```

Більш детальна інформація представлена у розділі [Контролери](structure-controllers.md).


Віджети
-------

У Yii 2.0 клас [[yii\base\Widget]] використовується як базовий клас для віджетів, аналогічно `CWidget` у Yii 1.1.

Для кращої підтримки фреймворку в IDE, Yii 2.0 використовує новий синтаксис для віджетів. Нові статичні методи 
[[yii\base\Widget::begin()|begin()]], [[yii\base\Widget::end()|end()]], та [[yii\base\Widget::widget()|widget()]]
використовуються таким чином:

```php
use yii\widgets\Menu;
use yii\widgets\ActiveForm;

// Зверніть увагу, що ви повинні виводити результат
echo Menu::widget(['items' => $items]);

// Вказуємо масив для конфігурації властивостей обʼєкта
$form = ActiveForm::begin([
    'options' => ['class' => 'form-horizontal'],
    'fieldConfig' => ['inputOptions' => ['class' => 'input-xlarge']],
]);
... поля форми ...
ActiveForm::end();
```

Більш детальна інформація представлена у розділі [Віджети](structure-widgets.md).


Теми
----

У Yii 2.0 теми працюють абсолютно по-іншому. Тепер вони засновані на механізмі співставлення шляхів вихідного файлу
представлення із темізованим файлом. Наприклад, якщо використовується співставлення шляхів
`['/web/views' => '/web/themes/basic']`, то темізована версія файлу представлення `/web/views/site/index.php` буде
знаходитися у `/web/themes/basic/site/index.php`. З цієї причини теми можуть бути застосовані до будь-якого файлу
представлення, навіть до представлення, яке відрендерене всередині контексту контролера або віджету. Також, більше 
не існує компонента `CThemeManager`. Замість цього, `theme` є конфігурованою властивістю компонента додатка `view`.

Більш детальна інформація представлена у розділі [Темізація](output-theming.md).


Консольні додатки
-----------------

Консольні додатки тепер організовані як контролери, аналогічно веб додаткам. Консольні контролери
повинні бути успадковані від класу [[yii\console\Controller]], аналогічного `CConsoleCommand` у версії 1.1.

Для виконання консольної команди, використовуйте `yii <маршрут>`, де `<маршрут>` це маршрут контролера
(наприклад, `sitemap/index`). Додаткові анонімні аргументи будуть передані у якості параметрів відповідній дії
контролера, у той час, як іменовані аргументи будуть передані у відповідності із оголошеннями у
[[yii\console\Controller::options()]].

Yii 2.0 підтримує автоматичну генерацію довідкової інформації із блоків коментарів.

Більш детальна інформація представлена у розділі [Консольні команди](tutorial-console.md).


I18N
----

У Yii 2.0 були прибрані вбудовані форматтери часу та чисел на користь 
[PECL intl PHP розширення](http://pecl.php.net/package/intl).

Переклад повідомлень тепер здійснюється через компонент додатка `i18n`. Даний компонент управляє безліччю вихідних сховищ
повідомлень, що дозволяє вам використовувати різні сховища для вихідних повідомлень залежно від категорії повідомлення.

Більш детальна інформація представлена у розділі [Інтернаціоналізація](tutorial-i18n.md).


Фільтри дій
-----------

Фільтри дій тепер зроблені за допомогою поведінок. Для визначення нового фільтру - успадкуйте від [[yii\base\ActionFilter]].
Для використання фільтра - прикріпіть його до контролера у якості поведінки. Наприклад, для використання фільтра
[[yii\filters\AccessControl]] слід зробити наступне:

```php
public function behaviors()
{
    return [
        'access' => [
            'class' => 'yii\filters\AccessControl',
            'rules' => [
                ['allow' => true, 'actions' => ['admin'], 'roles' => ['@']],
            ],
        ],
    ];
}
```

Більш детальна інформація представлена у розділі [Фільтри](structure-filters.md).


Ресурси
-------

У Yii 2.0 представлена нова можливість *звʼязки ресурсів*, яка замінює концепт пакетів скриптів у Yii 1.1.

Звʼязка ресурсів - це колекція файлів ресурсів (наприклад, Javascript файли, CSS файли, файли зображень, і т. п.)
у певній папці. Кожна звʼязка ресурсів представлена​класом, успадкованим від [[yii\web\AssetBundle]].
Звʼязка ресурсів стає доступною через веб, за допомогою реєстрації її методом [[yii\web\AssetBundle::register()]]. 
На відміну від Yii 1.1, сторінка, яка реєструє звʼязку ресурсів, автоматично буде містити посилання на 
Javascript і CSS файли, які зазначені у звʼязці.

Більш детальна інформація представлена у розділі [Ресурси](structure-assets.md).


Хелпери
-------

У Yii 2.0 включено багато широко використовуваних статичних класів.

* [[yii\helpers\Html]]
* [[yii\helpers\ArrayHelper]]
* [[yii\helpers\StringHelper]]
* [[yii\helpers\FileHelper]]
* [[yii\helpers\Json]]

Більш детальна інформація представлена у розділі [Хелпери](helper-overview.md).


Форми
-----

Yii 2.0 вводить нове поняття *поле* для побудови форм за допомогою [[yii\widgets\ActiveForm]]. Поле - це
контейнер, що містить лейбл, поле введення, повідомлення про помилку і/або допоміжний текст.
Поле представлено обʼєктом [[yii\widgets\ActiveField|ActiveField]]. Використовуючи поля, ви можете будувати
форми набагато простіше, ніж це було раніше:

```php
<?php $form = yii\widgets\ActiveForm::begin(); ?>
    <?= $form->field($model, 'username') ?>
    <?= $form->field($model, 'password')->passwordInput() ?>
    <div class="form-group">
        <?= Html::submitButton('Login') ?>
    </div>
<?php yii\widgets\ActiveForm::end(); ?>
```

Більш детальна інформація представлена у розділі [Робота з формами](input-forms.md).


Конструктор запитів
-------------------

У версії 1.1, побудова запиту була розкидана серед декількох класів, включаючи `CDbCommand`,
`CDbCriteria` та `CDbCommandBuilder`. У Yii 2.0 запит до БД представлений в рамках обʼєкта [[yii\db\Query|Query]],
який може бути перетворений у SQL вираз за допомогою [[yii\db\QueryBuilder|QueryBuilder]]. Наприклад,

```php
$query = new \yii\db\Query();
$query->select('id, name')
      ->from('user')
      ->limit(10);

$command = $query->createCommand();
$sql = $command->sql;
$rows = $command->queryAll();
```

Найкращим способом використання даних методів є робота з [Active Record](db-active-record.md).

Більш детальна інформація представлена у розділі [Конструктор запитів](db-query-builder.md).


Active Record
-------------

У Yii 2.0 внесено безліч змін в роботу [Active Record](db-active-record.md). Два основних з них включають в себе
побудову запитів і роботу із звʼязками.

Клас `CDbCriteria` у версії 1.1 був замінений на [[yii\db\ActiveQuery]] у Yii 2.0. Це клас успадковується від
[[yii\db\Query]] і таким чином отримує всі методи, які необхідні для побудови запиту. Для побудови запиту вам слід
викликати метод  [[yii\db\ActiveRecord::find()]]:

```php
// Отримуємо всіх *активних* клієнтів і сортуємо їх по ID
$customers = Customer::find()
    ->where(['status' => $active])
    ->orderBy('id')
    ->all();
```

Для оголошення звʼязку слід просто оголосити геттер, який повертає обʼєкт [[yii\db\ActiveQuery|ActiveQuery]].
Імʼя властивості, яке визначене геттером, представляє собою назву звʼязку. Наприклад, наступний код оголошує звʼязок
`orders` (у версії 1.1 вам потрібно було б оголосити звʼязки в одному центральному місці - `relations()`):

```php
class Customer extends \yii\db\ActiveRecord
{
    public function getOrders()
    {
        return $this->hasMany('Order', ['customer_id' => 'id']);
    }
}
```

Тепер ви можете використовувати вираз `$customer->orders` для отримання всіх замовлень клієнта із звʼязаної таблиці.
Ви також можете використовувати наступний код, щоб застосувати потрібні умови "на льоту":

```php
$orders = $customer->getOrders()->andWhere('status=1')->all();
```

Yii 2.0 здійснює жадібне завантаження (eager loading) звʼязку по-іншому, на відміну від версії 1.1. Зокрема,
у версії 1.1 для вибору даних із основної і звʼязаної таблиць буде використаний запит JOIN. У Yii 2.0 будуть виконані
два запити без використання JOIN: перший запит повертає дані для основної таблиці, а другий - для звʼязаної,
за допомогою фільтрації по первинних ключах основної таблиці.

Замість того, щоб повертати обʼєкти [[yii\db\ActiveRecord|ActiveRecord]], ви можете використовувати метод
[[yii\db\ActiveQuery::asArray()|asArray()]] при побудові запиту, для вибірки великої кількості записів.
Це змусить повернути результат запиту у якості масива, що може суттєво знизити час, який потрібен ЦПУ і памʼяті
при великій кількості записів. Наприклад:

```php
$customers = Customer::find()->asArray()->all();
```

Ще одна зміна повʼязана з тим, що ви більше не можете визначати значення по-замовчуванням як властивостей. 
Ви повинні встановити їх у методі `init` вашого класу, якщо це потрібно.

```php
public function init()
{
    parent::init();
    $this->status = self::STATUS_NEW;
}
```

Також у версії 1.1 були деякі проблеми із перевизначенням конструктора ActiveRecord. Дані проблеми не присутні
у версії 2.0. Зверніть увагу, що при додаванні параметрів у конструктор, вам, можливо, знадобиться перевизначити метод
[[yii\db\ActiveRecord::instantiate()]]. Перевизначення може не знадобитися, якщо параметри, передані в конструктор
матимуть значення за умовчанням, наприклад `null`.

Існує також безліч інших покращень у ActiveRecord. Більш детальна інформація про конфігурацію представлена у розділі
[Active Record](db-active-record.md).


Компонент додатку `user`
------------------------

Клас `CWebUser` у версії 1.1 тепер замінений класом [[yii\web\User]], а також більше не існує класу `CUserIdentity`.
Замість цього, ви повинні надати реалізацію інтерфейсу [[yii\web\IdentityInterface]], що набагато простіше у використанні.

Більш детальна інформація представлена у розділах [Аутентифікація](security-authentication.md),
[Авторизація](security-authorization.md) та [Шаблон додатка advanced](tutorial-advanced-app.md).


Розбір та генерація URL
-----------------------

Робота з URL в Yii 2.0 аналогічна тій, що була у версії 1.1. Основна зміна полягає в тому, що тепер підтримуються
додаткові параметри. Наприклад, якщо у вас є правило, оголошене наступним чином, то воно співпаде з `post/popular` та
`post/1/popular`. У версії 1.1 вам довелося б використовувати два правила для отримання того ж результату.

```php
[
    'pattern' => 'post/<page:\d+>/<tag>',
    'route' => 'post/index',
    'defaults' => ['page' => 1],
]
```

Більш детальна інформація представлена у розділі [Розбір та генерація URL](runtime-url-handling.md).

Використання Yii 1.1 разом із 2.x
---------------------------------

Інформація про використання коду для Yii 1.1 разом із Yii 2.0 представлена у розділі
[Одночасне використання Yii 1.1 та 2.0](extend-using-v1-v2.md).
