The Definitive Guide to Yii 2.0
===============================

This tutorial is released under the [Terms of Yii Documentation](http://www.yiiframework.com/doc/terms/).

All Rights Reserved.

2014 (c) Yii Software LLC.


Introduction
------------

- [Overview](overview.md) - What is Yii and what is it good for?

Getting started
---------------

- [Upgrading from 1.1 to 2.0](upgrade-from-v1.md)
- [Installation](installation.md) - How to download Yii and configure the Webserver?
- [Configuration](configuration.md) - Configuration of a Yii application
- [Basic Application Template](apps-basic.md) - A template to start a basic frontend application.
- [Advanced Application Template](apps-advanced.md) - The basis for more advanced applications.
- [Creating your own Application structure](apps-own.md) - Learn how to start from scratch.

Base concepts
-------------

- [Basic concepts of Yii](basics.md) - The Object and Component class, Path aliases and autoloading
- [MVC](mvc.md) - Implementation of MVC in Yii and a typical MVC application flow
  - [Model](model.md) - The Yii Model provides Attributes, Scenarios and data Validation
  - [View](view.md) - Rendering Views applying layouts, using Widgets and asset management
  - [Controller](controller.md) - controller actions, routing and action filters
- [Event Handling](events.md) - The Yii event handling mechanism
- [Behaviors](behaviors.md)


Database
--------

- [Basics](database-basics.md) - Connecting to a database, basic queries, transactions and schema manipulation
- [Query Builder](query-builder.md) - Querying the database using a simple abstraction layer
- [ActiveRecord](active-record.md) - The active record ORM, retrieving and manipulating records and defining relations
- [Database Migration](console-migrate.md) - Versioning your database with database migration

Developers Toolbox
------------------

- [Helper Classes](helpers.md)
- [Automatic Code Generation](gii.md)
- [Debug toolbar and debugger](module-debug.md)
- [Error Handling](error.md)
- [Logging](logging.md)

Extensions and 3rd party libraries
----------------------------------

- [Composer](composer.md) - How to manage applications dependencies via composer
- [Extending Yii](extensions.md)
- [Template engines](template.md) - Using template engines such as Smarty or Twig
- [Using Yii together with 3rd-Party Systems](using-3rd-party-libraries.md) - Using Yii in 3rd-Party Systems and using Yii 1 and 2 together

Security and access control
---------------------------

- [Authentication](authentication.md) - Identifying Users
- [Authorization](authorization.md) - Access control and RBAC
- [Security](security.md) - Hashing and verifying passwords, encryption
- [Views security](view.md#security) - how to prevent XSS

Data providers, lists and grids
-------------------------------

- [Overview](data-overview.md)
- [Data providers](data-providers.md)
- [Data widgets](data-widgets.md)
- [Grid](data-grid.md)

Advanced Topics
---------------

- [Asset Management](assets.md)
- [Working with forms](form.md)
- [Implementing RESTful Web Service APIs](rest.md)
- [Bootstrap widgets](bootstrap-widgets.md) - Using [twitter bootstrap](http://getbootstrap.com/)
- [Theming](theming.md)
- [Caching](caching.md) - Caching data, page fragments and http requests
- [Internationalization](i18n.md) - Message translation and formatting
- [URL Management](url.md) - routing, customized urls and SEO
- [Console Application](console.md)
- [Performance Tuning](performance.md)
- [Testing](testing.md)
- [Managing Test Fixtures](test-fixture.md)
- [Service Locator and Dependency Injection](di.md)

References
----------

- [Model validation reference](validation.md)
- [Official Composer documentation](http://getcomposer.org)
