O que é o Yii
=============

O Yii é um framework PHP de alta performance e baseado em componentes, para o
desenvolvimento rápido de aplicações web modernas. O nome Yii (pronunciado `Ii`
ou `[ji:]`) significa "simples e evolutivo" em chinês. Ele também pode ser considerado
como um acrônimo de **Yes It Is** (*sim, ele é*)!


Para quê o Yii é melhor?
------------------------

O Yii é um framework de programação web genérico, o que significa que ele pode
ser usado para o desenvolvimento de todo tipo de aplicações web baseadas em PHP.
Por causa de sua arquitetura baseada em componentes e suporte sofisticado a
caching, ele é especialmente adequado para o desenvolvimento de aplicações de
larga escala como portais, fóruns, sistemas de gerenciamento de conteúdo (CMS),
projetos de e-commerce, Web services RESTful, e assim por diante.


Como o Yii se compara a outros frameworks?
------------------------------------------

- Como a maioria dos frameworks PHP, o Yii implementa o padrão de arquitetura MVC
  (Modelo-Visão-Controlador) e promove a organização do código baseada nesse padrão.
- O Yii tem a filosofia de que o código deveria ser escrito de uma maneira simples,
  porém elegante. Ele nunca tentará exagerar no design com o propósito principal
  de seguir algom padrão de projeto.
- O Yii é um framework full-stack, fornecendo muitas funcionalidades comprovadas
  e prontas para o uso, tais como: construtores de consultas (query builders) e
  ActiveRecord, tanto para bancos de dados relacionais quanto NoSQL; suporte ao
  desenvolvimento de APIs RESTful; suporte a caching de múltiplas camadas; e mais.
- O Yii é extremamente extensível. Você pode personalizá-lo ou substituir quase
  todas as partes do código do core. Você também pode se aproveitar de sua
  sólida arquitetura de extensões, para utilizar ou desenvolver extensões
  que podem ser redistribuídas.
- A alta performance é sempre um objetivo principal do Yii.

O Yii não é um show de um homem só, ele é suportado pelo [forte time de desenvolvedores do core][] 
bem como por uma ampla comunidade com muitos profissionais constantemente
contribuindo com o desenvolvimento do Yii. A equipe de desenvolvedores do Yii
presta muita atenção às últimas tendências do desenvolvimento Web, e às
melhores práticas e funcionalidades encontradas em outros frameworks e projetos.
As melhores práticas e funcionalidades mais relevantes encontradas noutros lugares
são regularmente incorporadas no core do framework e expostas via interfaces
simples e elegantes.

[forte time de desenvolvedores do core]: http://www.yiiframework.com/about/

Versões do Yii
--------------

Atualmente, o Yii tem duas versões principais disponíveis: a 1.1 e a 2.0. A Versão
1.1 é a geração antiga e agora está em modo de manutenção. A versão 2.0 é uma
reescrita completa do Yii, adotando as tecnologias e protocolos mais recentes, incluindo
o Composer, PSR, namespaces, traits, e assim por diante. A versão 2.0 representa
a última geração do framework e receberá os nossos esforços principais de
desenvolvimento nos próximos anos. Este guia trata principalmente da versão 2.0.


Requisitos e Pré-requisitos
---------------------------

O Yii 2.0 requer o PHP 5.4.0 ou superior. Você pode encontrar os requisitos mais
detalhados para funcionalidades em particular executando o verificador de requisitos
(requirement checker) incluído em todos os pacotes do Yii.

Utilizar o Yii requer conhecimentos básicos sobre programação orientada a objetos
(OOP), uma vez que o Yii é um framework puramente OOP. O Yii 2.0 também utiliza
as funcionalides mais recentes do PHP, tais como [namespaces](http://www.php.net/manual/en/language.namespaces.php) 
e [traits](http://www.php.net/manual/en/language.oop5.traits.php). Compreender
estes conceitos lhe ajudará e entender mais facilmente o Yii 2.0

