Автозавантаження класів
=================
Пошук і підключення файлів класів в Yii реалізовано за допомогою
[автозавантаження класів](http://www.php.net/manual/ru/language.oop5.autoload.php). Фреймворк надає свій швидкий сумісний з [PSR-4](https://github.com/php-fig/fig-standards/blob/master/proposed/psr-4-autoloader/psr-4-autoloader.md)
автозавантажувач, який встановлюється в момент підключення `Yii.php`.

> Примітка: Для простоти оповіді, в цьому розділі ми будемо говорити тільки про автозавантаження класів. Тим не менш, все описане застосовно до інтерфейсів і трейтам.

Как использовать автозагрузчик Yii <a name="using-yii-autoloader"></a>
--------------------------------------------------------------

При использовании автозагрузчика классов Yii следует соблюдать два простых правила создания и именования классов:

* Каждый класс должен принадлежать пространству имён (то есть `foo\bar\MyClass`).
* Каждый класс должен находиться в отдельном файле, путь к которому определятся следующим правилом:

```php
// $className — это абсолютное имя класса, начинающееся с "\"
$classFile = Yii::getAlias('@' . str_replace('\\', '/', $className) . '.php');
```

Например, если абсолютное имя класса `foo\bar\MyClass`, то [псевдоним пути](concept-aliases.md) данного файла будет
`@foo/bar/MyClass.php`. Для того, чтобы данный псевдоним можно было преобразовать в путь к файлу, необходимо чтобы
либо `@foo` либо `@foo/bar` являлся [корневым псевдонимом](concept-aliases.md#defining-aliases).

При использовании [шаблона приложения basic](start-basic.md) вы можете хранить свои классы в пространстве имён `app`.
В этом случае они будут загружаться автоматически без создания нового псевдонима. Это работает потому как `@app`
является [заранее определённым псевдонимом](concept-aliases.md#predefined-aliases) и такое имя класса как
`app\components\MyClass` в соответствии с описанным выше алготимом преобразуется в путь
`директорияПриложения/components/MyClass.php`.

В [шаблоне приложения advanced](tutorial-advanced-app.md) каждый уровень приложения обладает собственным корневым
псевдонимом. Например, для frontend корневым псевдонимом является `@frontend`, а для backend — `@backend`. Это позволяет
разместить классы frontend в пространство имён `frontend`, а классы backend в пространство имён `backend`. При этом
классы будут загружены автоматически.


Карта классов <a name="class-map"></a>
---------------------------------

Автозагрузчик Yii поддерживает *карту классов*. Эта возможность позволяет указать путь к файлу для каждого имени класса.
При загрузке класса автозагрузчик проверяет наличие класса в карте. Если он там есть, соответствующий файл будет загружен
напрямую без каких-либо дополнительных проверок. Это делает автозагрузку очень быстрой. Все классы самого фреймворка
загружаются именно этим способом.

Вы можете добавить класс в карту `Yii::$classMap` следующим образом:

```php
Yii::$classMap['foo\bar\MyClass'] = 'path/to/MyClass.php';
```

Для указания путей к файлам классов можно использовать [псевдонимы](concept-aliases.md). Карту классов необходимо
сформировать в процессе [первоначальной загрузки](runtime-bootstrapping.md) так как она должна быть готова до
использования классов.


Использование других автозагрузчиков <a name="using-other-autoloaders"></a>
------------------------------------------------------------------

Так как Yii использует Composer в качестве менеджера зависимостей, рекомендуется дополнительно установить его автозагрузчик.
Если вы используете какие-либо сторонние библиотеки, в которых есть свои автозагрузчики, эти автозагрузчики также необходимо
установить.

При использовании дополнительных автозагрузчиков файл `Yii.php` должен быть подключен *после* их установки. Это позволит
автозагрузчику Yii первым пробовать загрузить класс. К примеру, приведённый ниже код взят из
[входного скрипта](structure-entry-scripts.md) [шаблона приложения basic](start-basic.md). Первая строка устанавливает
автозагрузчик Composer, а вторая — автозагрузчик Yii:

```php
require(__DIR__ . '/../vendor/autoload.php');
require(__DIR__ . '/../vendor/yiisoft/yii2/Yii.php');
```

Вы можете использовать автозагрузчик Composer без автозагрузчика Yii. Однако, скорость автозагрузки в этом случае
может уменьшится. Также вам будет необходимо сдедовать правилам автозагрузчика Composer.

> Информация: Если вы не хотите использовать автозагрузчик Yii, создайте свою версию файла `Yii.php`
  и подключите его в [входном скрипте](structure-entry-scripts.md).


Автозагрузка классов расширений <a name="autoloading-extension-classes"></a>
-------------------------------------------------------------------

Автозагрузчик Yii может автоматически загружать классы [расширений](structure-extensions.md) в том случае, если соблюдается
единственное правило. Расширение должно правильно описать раздел 'autoload' в файле 'composer.json'. Более подробно об
этом можно узнать из [официальной документации Composer](https://getcomposer.org/doc/04-schema.md#autoload).

Если вы не используете автозагрузчик Yii, то классы расширений могут быть автоматически загружены с помощью
автозагрузчика Composer.
