Псевдонимы 
=========

Псевдонимы используются для обозначения путей к файлам или URL адресов и помогают избежать использования абсолютных путей
или URL в коде. Для того, чтобы не перепутать псевдоним с обычным путём к файлу или URL, он должен начинаться с `@`. В Yii
имеется множество заранее определённых псевдонимов. Например, `@yii` указывает на директорию, в которую был установлен
Yii framework, а `@web` можно использовать для получения базового URL текущего приложения.


Создание псевдонимов <a name="defining-aliases"></a>
----------------------------------------------

Для создания псевдонима пути к файлу или URL используется метод [[Yii::setAlias()]]:

```php
// псевдоним пути к файлу
Yii::setAlias('@foo', '/path/to/foo');

// псевдоним URL
Yii::setAlias('@bar', 'http://www.example.com');
```

> Примечание: псевдоним пути к файлу или URL *не* обязательно указывает на существующий файл или ресурс.

Используя уже заданный псевдоним, вы можете получить на основе него новый без вызова [[Yii::setAlias()]]. Сделать это
можно, добавив в его конец `/`, за которым следует один или более сегментов пути. Псевдонимы, определённые при помощи
[[Yii::setAlias()]], являются *корневыми псевдонимами*, в то время как полученные из них называются *производными
псевдонимами*. К примеру, `@foo` является корневым псевдонимом, а `@foo/bar/file.php` — производным.

Вы можете задать новый псевдоним, используя ранее созданный псевдоним (не важно, корневой он или производный):

```php
Yii::setAlias('@foobar', '@foo/bar');
```

Корневые псевдонимы, как правило, создаются на этапе [предварительной загрузки (bootstrapping)](runtime-bootstrapping.md).
Например, вы можете вызвать [[Yii::setAlias()]] в [входном скрипте](structure-entry-scripts.md). Для удобства, в
[приложении (Application)](structure-applications.md) предусмотрено свойство `aliases`, которое можно задать через
[конфигурацию приложения](concept-configurations.md):

```php
return [
    // ...
    'aliases' => [
        '@foo' => '/path/to/foo',
        '@bar' => 'http://www.example.com',
    ],
];
```


Преобразование псевдонимов <a name="resolving-aliases"></a>
----------------------------------------------------

Метод [[Yii::getAlias()]] преобразует корневой псевдоним в путь к файлу или URL, который этот псевдоним представляет.
Этот же метод может работать и с производными псевдонимами:

```php
echo Yii::getAlias('@foo');               // выведет: /path/to/foo
echo Yii::getAlias('@bar');               // выведет: http://www.example.com
echo Yii::getAlias('@foo/bar/file.php');  // выведет: /path/to/foo/bar/file.php
```

Путь или URL, представленный производным псевдонимом, определяется путём замены в нём части, соответствующей корневому
псевдониму, на соответствующий ему путь или URL.

> Примечание: Метод [[Yii::getAlias()]] не проверяет фактического существования получаемого пути или URL.

Корневой псевдоним может содержать знаки '/'. При этом метод [[Yii::getAlias()]] корректно определит, какая часть
псевдонима является корневой и верно сформирует путь или URL:

```php
Yii::setAlias('@foo', '/path/to/foo');
Yii::setAlias('@foo/bar', '/path2/bar');
Yii::getAlias('@foo/test/file.php');  // выведет: /path/to/foo/test/file.php
Yii::getAlias('@foo/bar/file.php');   // выведет: /path2/bar/file.php
```

Если бы `@foo/bar` не был объявлен корневым псевдонимом, последняя строка вывела бы  `/path/to/foo/bar/file.php`.


Использование псевдонимов <a name="using-aliases"></a>
------------------------------------------------

Псевдонимы распознаются во многих частях Yii без необходимости предварительно вызывать [[Yii::getAlias()]] для
получения пути или URL. Например, [[yii\caching\FileCache::cachePath]] принимает как обычный путь к файлу, так и
псевдоним пути благодаря префиксу `@`, который позволяет их различать.

```php
use yii\caching\FileCache;

$cache = new FileCache([
    'cachePath' => '@runtime/cache',
]);
```

Для того, чтобы узнать поддерживает ли метод или свойство псевдонимы, обратитесь к документации API.


Заранее определённые псевдонимы <a name="predefined-aliases"></a>
----------------------------------------------------------

В Yii заранее определны псевдонимы для часто используемых путей к файлам и URL:

- `@yii`: директория, в которой находится файл `BaseYii.php` (директория фреймворка).
- `@app`: [[yii\base\Application::basePath|базовый путь]] текущего приложения.
- `@runtime`: [[yii\base\Application::runtimePath|директория runtime]] текущего приложения.
- `@vendor`: [[yii\base\Application::vendorPath|директория vendor Composer].
- `@webroot`: вебрут текущего веб приложения (там где `index.php`).
- `@web`: базовый URL текущего приложения.

Псевдоним `@yii` задаётся в момент подключения файла `Yii.php` во [входном скрипте](structure-entry-scripts.md).
Остальные псевдонимы задаются в конструкторе приложения в момент применения [конфигурации](concept-configurations.md).


Псевдонимы расширений <a name="extension-aliases"></a>
------------------------------------------------

Для каждого [расширения](structure-extensions.md), устанавливаемого через Composer, автоматически задаётся псевдоним.
Его имя соответствует корневому пространству имён расширения в соответствии с его `composer.json`. Псевдоним представляет
путь к корневой директории пакета. Например, если вы установите расширение `yiisoft/yii2-jui`, то вам автоматически станет
доступен псевдоним `@yii/jui`. Он создаётся на этапе [первоначальной загрузки (bootstrapping)](runtime-bootstrapping.md)
примерно так:

```php
Yii::setAlias('@yii/jui', 'VendorPath/yiisoft/yii2-jui');
```
