What is Yii
===========

Yii is a high performance, component-based PHP framework for rapidly developing modern Web applications.
The name Yii (pronounced `Yee` or `[ji:]`) means simple and evolutionary in Chinese. It can also
be considered as the acronym for **Yes It Is**!


What is Yii Best for?
---------------------

Yii is a generic Web programming framework, meaning that it can be used for developing all kinds
of Web applications based on PHP. Because of its component-based architecture and sophisticated caching
support, it is especially suitable for developing large-scale applications such as portals, forums, content
management systems (CMS), e-commerce projects, RESTful Web services, and so on.


How does Yii Compare with Other Frameworks?
-------------------------------------------

- Like most PHP frameworks, Yii implements the MVC (Model-View-Controller) design pattern and promotes code
  organization based on this pattern.
- Yii takes the philosophy that code should be written in a simple yet elegant way. It will never try to
  over-design things mainly for the purpose of following some design pattern.
- Yii is a full-stack framework providing many proven and ready-to-use features, such as query builders
  and ActiveRecord supporting relational and NoSQL databases, RESTful API development support, multi-tier
  caching support, etc.
- Yii is extremely extensible. You can customize or replace nearly every piece of core code. You can also
  take advantage of its solid extension architecture, use or develop redistributable extensions.
- High performance is always a primary goal of Yii.

Yii is not a one-man show, it is backed up by a [strong core developer team][] as well as a large community
with many professionals who are constantly contributing to the development of Yii. The Yii developer team
is keeping a close eye on the latest trends of Web development and the best practices and features
found in other frameworks and projects. They are being carefully incorporated into the core framework and exposed
via simple and elegant interfaces.

[strong core developer team]: http://www.yiiframework.com/about/

Yii Versions
------------

Yii has two major versions available currently: 1.1 and 2.0. Version 1.1 is the old generation and is
currently under maintenance mode. Version 2.0 is a complete rewrite of Yii by adopting the latest
technologies and protocols, such as Composer, PSR, namespaces, traits, etc. Version 2.0 represents the latest
generation of the framework and will receive our main development efforts in the next few years.
This guide is mainly about version 2.0.


Requirements and Prerequisites
------------------------------

Yii 2.0 requires PHP 5.4.0 or above. You may find out more detailed requirements for individual features
by running the requirement checker included in every release.

Using Yii requires basic knowledge about object-oriented programming (OOP), as Yii is a pure OOP-based framework.
Yii 2.0 also makes use of the latest features of PHP, such as [namespaces](http://www.php.net/manual/en/language.namespaces.php),
[traits](http://www.php.net/manual/en/language.oop5.traits.php). Understanding these concepts will help
you pick up Yii 2.0 more easily.

