Кэширование страниц
============

Кэширование страниц — это кэширование всего содержимого страницы на стороне сервера. Позже когда эта страница 
будет снова запрошена, сервер вернет её из кэша вместо того что бы генерировать её заново.

Кэширование страниц осуществляется при помощи [[yii\filters\PageCache]] и [фильтра действия](structure-filters.md).
Это может быть использовано в классе контроллера как показано ниже:

```php
public function behaviors()
{
    return [
        [
            'class' => 'yii\filters\PageCache',
            'only' => ['index'],
            'duration' => 60,
            'variations' => [
                \Yii::$app->language,
            ],
            'dependency' => [
                'class' => 'yii\caching\DbDependency',
                'sql' => 'SELECT COUNT(*) FROM post',
            ],
        ],
    ];
}
```

Приведенный выше код устанавливает, что кэширования страницы должно использоваться только для `index` действия; контент
этой страницы должен быть закэширован не более чем на 60 секунд и должен будет измениться на текущий язык приложения;
и эта кэшированная страница должна быть признана просроченной, если общее количество постов было изменено.

Как вы можете видеть, кэширование страниц очень похоже на [кэширования фрагмента](caching-fragment.md). Оба этих варианта
поддерживают параметры: `duration` (продолжительность), `dependencies` (зависимости), `variations` (вариации), и `enabled`
(включения). Их главное отличие заключается в том что кэширования страницы реализована как
[фильтр действия](structure-filters.md) а кэширования фрагмента как [виджет](structure-widgets.md).

Вы можете использовать [кэширования фрагмента](caching-fragment.md), a также
[динамический контент](caching-fragment.md#dynamic-content) вместе с кэшированием страницы.
