Running Applications
====================

You now have a working Yii application which can be accessed via URL `http://hostname/index.php`.
In this section, we will introduce what functionalities this application has, how the code is organized,
and how the application handles requests in general.

> Info: For simplicity, throughout this "Getting Started" tutorial we assume that you have set `basic/web`
  as the document root of your Web server. If you have not done so, the URL for accessing
  your application could be `http://hostname/basic/web/index.php`, or something similar.
  Please adjust the URLs accordingly in our descriptions.


Functionalities
---------------

The application that you have installed has four pages:

* the homepage is the page displayed when you access the URL `http://hostname/index.php`;
* the "About" page;
* the "Contact" page displays a contact form that allows end users to contact you by filling out the form;
* the "Login" page displays a login form that can be used to authenticate end users. Try logging in
  with "admin/admin", and you will find the "Login" main menu item will change to "Logout".

These pages share a common header and footer. The header contains a main menu bar to allow navigate
among different pages.

You should also see a toolbar sticking at the bottom of the browser window when it displays any of the above pages.
This is a useful [debugger tool](tool-debugger.md) provided by Yii to help you check various debugging information
about the application execution, such as log messages, response status, database queries, and so on.


Application Structure
---------------------

The following is a list of the most important directories and files in your application,

```
basic/                  application base path
    composer.json       used by Composer, describes package information
    config/             contains application and other configurations
        console.php     the console application configuration
        web.php         the Web application configuration
    commands/           contains console command classes
    controllers/        contains controller classes
    models/             contains model classes
    runtime/            contains files generated by Yii during runtime, such as logs, cache files
    vendor/             contains the installed Composer packages, including the Yii framework
    views/              contains view files
    web/                application Web root, contains Web accessible files
        assets/         contains published asset files (js, css) by Yii
        index.php       the entry script of the application
    yii                 the Yii console command execution script
```

In general, the files in the application can be divided into two parts: those under `basic/web` and those
under other directories. The former can be directly accessed from Web, while the latter can/should not.

Your application uses a single entry `web/index.php`. It is the only PHP script that is directly accessible from Web.
It takes ALL Web requests, creates an [application](structure-applications.md) instance to handle the requests,
and then sends back the responses.

Yii implements the [model-view-controller (MVC)](http://wikipedia.org/wiki/Model-view-controller) design pattern,
as reflected in the above directory organization. The `models` directory contains all [model classes](structure-models.md),
the `views` directory contains all [view scripts](structure-views.md), and the `controllers` directory contains
all [controller classes](structure-controllers.md).

The following diagram shows the static structure of an application:

![Static structure of Yii application](images/application-structure.png)


Request Lifecycle
-----------------

The following diagram shows a typical workflow of a Yii application  handling a user request:

![Typical workflow of a Yii application](images/application-lifecycle.png)

1. A user makes a request of the URL `http://www.example.com/index.php?r=post/show&id=1`.
   The Web server handles the request by executing the bootstrap script `index.php`.
2. The bootstrap script creates an [[yii\web\Application|Application]] instance and runs it.
3. The Application instance obtains the detailed user request information from an application component named `request`.
4. The application determines which [controller](controller.md) and which action of that controller was requested.
   This is accomplished with the help of an application component named `urlManager`.
   For this example, the controller is `post`, which refers to the `PostController` class, and the action is `show`,
   whose actual meaning is determined by the controller.
5. The application creates an instance of the requested controller to further handle the user's request.
   The controller determines that the action `show` refers to a method named `actionShow` in the controller class.
   The controller then creates and executes any filters associated with this action (e.g. access control or benchmarking).
   The action is then executed, if execution is allowed by the filters (e.g., if the user has permission to execute that action).
6. The action creates a `Post` [model](model.md) instance, using the underlying database table, where the ID value of the corresponding record is `1`.
7. The action renders a [view](view.md) named `show`, providing to the view the `Post` model instance.
8. The view reads the attributes of the `Post` model instance and displays the values of those attributes.
9. The view executes some [widgets](view.md#widgets).
10. The view rendering result--the output from the previous steps--is embedded within a [layout](view.md#layout) to create a complete HTML page.
11. The action completes the view rendering and displays the result to the user.

