Повний посібник до 2.0
======================

Даний посібник випущено відповідно до [положень про документацію Yii](http://www.yiiframework.com/doc/terms/).

All Rights Reserved.

2014 © Yii Software LLC.


Введення
--------

* [Про Yii](intro-yii.md)
* [Оновлення із версії 1.1](intro-upgrade-from-v1.md)


Перше знайомство
----------------

* [Встановлення Yii](start-installation.md)
* [Запуск додатка](start-workflow.md)
* [Говоримо «Привіт»](start-hello.md)
* [Робота з формами](start-forms.md)
* [Робота з базами даних](start-databases.md)
* [Генерація коду за допомогою Gii](start-gii.md)
* [Що далі?](start-looking-ahead.md)


Структура додатка
-----------------

* [Огляд](structure-overview.md)
* [Вхідні скрипти](structure-entry-scripts.md)
* [Додатки](structure-applications.md)
* [Компоненти додатка](structure-application-components.md)
* [Контролери](structure-controllers.md)
* [Представлення](structure-views.md)
* [Моделі](structure-models.md)
* **TBD** [Фільтри](structure-filters.md)
* **TBD** [Віджети](structure-widgets.md)
* **TBD** [Модулі](structure-modules.md)
* [Ресурси](structure-assets.md)
* **TBD** [Розширення](structure-extensions.md)


Обробка запитів
---------------

* **TBD** [Bootstrapping](runtime-bootstrapping.md)
* **TBD** [Роутінг](runtime-routing.md)
* **TBD** [Запити](runtime-requests.md)
* **TBD** [Відповіді](runtime-responses.md)
* **TBD** [Сесії та кукі](runtime-sessions-cookies.md)
* [Розбір та генерація URL](runtime-url-handling.md)
* [Обробка помилок](runtime-handling-errors.md)
* [Логування](runtime-logging.md)


Основні поняття
---------------

* [Компоненти](concept-components.md)
* [Властивості](concept-properties.md)
* [Події](concept-events.md)
* [Поведінки](concept-behaviors.md)
* [Конфігурації](concept-configurations.md)
* [Псевдоніми](concept-aliases.md)
* [Автозавантаження класів](concept-autoloading.md)
* [Service Locator](concept-service-locator.md)
* [Dependency Injection Container](concept-di-container.md)


Робота з базами даних
---------------------

* [Обʼєкти доступу до даних (DAO)](db-dao.md) - Зʼєднання з базою даних, прості запити, транзакції і робота зі схемою.
* [Конструктор запитів](db-query-builder.md) - Запити до бази даних через простий шар абстракції.
* [Active Record](db-active-record.md) - Отримання обʼєктів AR, робота з ними та визначення звʼязків.
* [Міграції](db-migrations.md) - Контроль версій схеми даних при роботі в команді.
* **TBD** [Sphinx](db-sphinx.md)
* **TBD** [Redis](db-redis.md)
* **TBD** [MongoDB](db-mongodb.md)
* **TBD** [ElasticSearch](db-elastic-search.md)


Отримання даних від користувача
-------------------------------

* [Створення форм](input-forms.md)
* [Валідація](input-validation.md)
* **TBD** [Завантаження файлів](input-file-uploading.md)
* **TBD** [Робота з декількома моделями](input-multiple-models.md)


Відображення даних
------------------

* **TBD** [Форматування даних](output-formatting.md)
* **TBD** [Посторінкове розбиття](output-pagination.md)
* **TBD** [Сортування](output-sorting.md)
* [Провайдери даних](output-data-providers.md)
* [Віджети для даних](output-data-widgets.md)
* [Темізація](output-theming.md)


Безпека
-------

* [Аутентифікація](security-authentication.md)
* [Авторизація](security-authorization.md)
* [Робота з паролями](security-passwords.md)
* **TBD** [Клієнти авторизації](security-auth-clients.md)
* **TBD** [Кращі практики](security-best-practices.md)


Кешування
---------

* [Огляд](caching-overview.md)
* [Кешуванная даних](caching-data.md)
* [Кешуванная фрагментів](caching-fragment.md)
* [Кешуванная сторінок](caching-page.md)
* [HTTP кешуванная](caching-http.md)


Веб-сервіси REST
----------------

* [Швидкий старт](rest-quick-start.md)
* [Ресурси](rest-resources.md)
* [Контролери](rest-controllers.md)
* [Роутінг](rest-routing.md)
* [Форматування відповіді](rest-response-formatting.md)
* [Аутентифікація](rest-authentication.md)
* [Обмеження кількості запитів](rest-rate-limiting.md)
* [Версіонування](rest-versioning.md)
* [Обробка помилок](rest-error-handling.md)


Інструменти розробника
----------------------

* [Відладочна панель та відладчик](tool-debugger.md)
* [Генерація коду з Gii](tool-gii.md)
* **TBD** [Генератор документації API](tool-api-doc.md)


Тестування
----------

* [Огляд](test-overview.md)
* **TBD** [Модульні тести](test-unit.md)
* **TBD** [Функціональні тести](test-functional.md)
* **TBD** [Приймальні тести](test-acceptance.md)
* [Фікстури](test-fixtures.md)


Розширення Yii
--------------

* [Створення розширень](extend-creating-extensions.md)
* [Розширення коду фреймворку](extend-customizing-core.md)
* [Використання сторонніх бібліотек](extend-using-libs.md)
* **TBD** [Інтеграція Yii в сторонні системи](extend-embedding-in-others.md)
* **TBD** [Одночасне використання Yii 1.1 та 2.0](extend-using-v1-v2.md)
* [Використання Composer](extend-using-composer.md)


Спеціальні теми
---------------

* [Шаблон додатка advanced](tutorial-advanced-app.md)
* [Створення додатка з нуля](tutorial-start-from-scratch.md)
* [Консольні команди](tutorial-console.md)
* [Інтернаціонализація](tutorial-i18n.md)
* [Відправка пошти](tutorial-mailing.md)
* [Вдосконалення продуктивності](tutorial-performance-tuning.md)
* **TBD** [Робота на shared хостингу](tutorial-shared-hosting.md)
* [Шаблонізатори](tutorial-template-engines.md)


Віджети
-------

* GridView: link to demo page
* ListView: link to demo page
* DetailView: link to demo page
* ActiveForm: link to demo page
* Pjax: link to demo page
* Menu: link to demo page
* LinkPager: link to demo page
* LinkSorter: link to demo page
* [Віджети Bootstrap](bootstrap-widgets.md)
* **TBD** [Віджети Jquery UI](jui-widgets.md)


Хелпери
-------

* [Огляд](helper-overview.md)
* **TBD** [ArrayHelper](helper-array.md)
* **TBD** [Html](helper-html.md)
* **TBD** [Url](helper-url.md)
* **TBD** [Security](helper-security.md)

