<?php
/**
 * @copyright Copyright (c) 2008 Yii Software LLC
 * @link http://www.yiiframework.com/
 * @license http://www.yiiframework.com/license/
 */

namespace yii\helpers;

/**
 * HtmlPurifier provides an ability to clean up HTML from any harmful code.
 *
 * Basic usage is the following:
 *
 * ```php
 * echo HtmlPurifier::process($html);
 * ```
 *
 * If you want to configure it:
 *
 * ```php
 * echo HtmlPurifier::process($html, array(
 *     'Attr.EnableID' => true,
 * ));
 * ```
 *
 * For more details please refer to HTMLPurifier documentation](http://htmlpurifier.org/).
 *
 * Note that you should add `ezyang/htmlpurifier` to your composer.json `require` section and run `composer install`
 * before using it.
 *
 * @author Alexander Makarov <sam@rmcreative.ru>
 * @since 2.0
 */
class HtmlPurifier extends BaseHtmlPurifier
{
}
