Компоненти додатка
=====================

Додатки є [сервіс локаторами](concept-service-locators.md). Вони зберігають багато так званих
*компонентів додатку*, які надають різноманітні інструменти для опрацювання запитів. Наприклад,
компоненти `urlManager` відповідає за маршрутизацію веб запитів до потрібного контролера; компонент `db` надає інструменти для работи з базою даних; і т. д.

Кожний компонент додатка має свій унікальний ID, який дозволяє ідентифікувати його серед інших різноманітних компонентів
в одному і тому ж додатку. Ви можете отримати доступ до компонента наступним чином:

```php
\Yii::$app->ComponentID
```

Наприклад, ви можете використовувати `\Yii::$app->db` для отримання [[yii\db\Connection|з’єднання з БД]],
і `\Yii::$app->cache` для отримання доступу до основного компонента [[yii\caching\Cache|кеша]], зареєстрованого в додатку.

Компонентами додатку можуть бути любі об’єкти. Ви можете зареєструвати їх з допомогою властивості [[yii\base\Application::components]] в [конфігурації](structure-applications.md#application-configurations) додатка.
Наприклад,

```php
[
    'components' => [
        // реєстрація "cache" компонента з допомогою назви класу
        'cache' => 'yii\caching\ApcCache',

        // реєстрація "db" компонента з допомогою масива конфігурації
        'db' => [
            'class' => 'yii\db\Connection',
            'dsn' => 'mysql:host=localhost;dbname=demo',
            'username' => 'root',
            'password' => '',
        ],

        // реєстрація "search" компонента з допомогою анонімної функції
        'search' => function () {
            return new app\components\SolrService;
        },
    ],
]
```

> Інформація: Хоча ви можете зареєструвати стільки компонентів в додатку скільки вам потрібно,
  все ж таки варто робити це осмислено. Компоненти додатку схожі на глобальні змінні. Використання дуже великої кількості компонетів додатку може потенційно зробити ваш код складним для розробки і тестування.
  В більшості випадків ви можете просто створити локальний компонент і використовувати його при необхідності.


## Вбудовані компоненти додатку <a name="core-application-components"></a>

В Yii є декілька *вбудованих* компонентів додатку, з фіксованими ID і конфігураціями за замовчуванням. Наприклад,
компонент [[yii\web\Application::request|request]] використовується для отримання інформації про запит користувача і розбору його в
певний [маршрут](runtime-routing.md); компонент [[yii\base\Application::db|db]] являє собою з’єднання з базою даних,
через яке ви можете виконувати запити. Саме з допомогою цих вбудованих компонентів Yii додатки можуть обрабляти
запит користувача.

Нижче наведений перелік вбудованих компонентів додатку. Ви можете конфігурувати їх так само як і інші компоненти додатку.
Коли ви конфігуруєте вбудований компонент додатку і не вказуєте клас цього компонента, то буде використовуватись значення за замовчуванням.

* [[yii\web\AssetManager|assetManager]]: використовується для керування і відображенням ресурсів додатку.
  Більш детальна інформація представлена ​​в розділі [Ресурси](output-assets.md);
* [[yii\db\Connection|db]]: являє собою з’єднання з базою даних, через яке ви можете виконувати запити.
  Зверніть увагу, що коли конфігуруєте даний компонент, ви маєте вказати клас компонента так як і решту необхідних параметрів, а саме такі як [[yii\db\Connection::dsn]].
  Більш детальна інформація представлена ​​в розділі [Об’єкти доступу до даних (DAO)](db-dao.md);
* [[yii\base\Application::errorHandler|errorHandler]]: здійснює опрацювання PHP помилок і виключень.
  Більш детальна інформація представлена ​​в розділі [Обробка помилок](runtime-handling-errors.md);
* [[yii\base\Formatter|formatter]]: форматує дані для відображення їх кінцевому користувачу. Наприклад, число може
  бути зображене з різноманітними розділителями, дата може бути зображена в форматі `long`.
  Більш детальна інформація представлена ​​в розділі [Форматування даних](output-formatting.md);
* [[yii\i18n\I18N|i18n]]: використовується для перекладу повідомлень і форматування.
  Більш детальна інформація представлена ​​в розділі [Інтернаціоналізація](tutorial-i18n.md);
* [[yii\log\Dispatcher|log]]: обробка і маршрутизація логів.
  Більш детальна інформація представлена ​​в розділі [Логування](runtime-logging.md);
* [[yii\swiftmailer\Mailer|mail]]: надає можливості для побудови і розсилки поштових повідомлень.
  Більш детальна інформація представлена ​​в розділі [Відправлення пошти](tutorial-mailing.md);
* [[yii\base\Application::response|response]]: являє собою дані від серверу, які будуть направлені користувачу.
  Більш детальна інформація представлена ​​в розділі [Відповіді](runtime-responses.md);
* [[yii\base\Application::request|request]]: являє собою запит, отриманий від кінцевого користувача.
  Більш детальна інформація представлена ​​в розділі [Запити](runtime-requests.md);
* [[yii\web\Session|session]]: інформація про сесії. Даний компонент доступний тільки в [[yii\web\Application|веб додатках]].
  Більш детальна інформація представлена ​​в розділі [Сесії і куки](runtime-sessions-cookies.md);
* [[yii\web\UrlManager|urlManager]]: використовується для розбору і побудови URL.
  Більш детальна інформація представлена ​​в розділі [Розбір і генерація URL](runtime-url-handling.md);
* [[yii\web\User|user]]: являє собою інформацію авторизованого користувача.
  Даний компонент доступний тільки в [[yii\web\Application|веб додатках]].
  Більш детальна інформація представлена ​​в розділі [Аутентифікація](security-authentication.md);
* [[yii\web\View|view]]: використовується для відображення представлень.
  Більш детальна інформація представлена ​​в розділі [Представлення](structure-views.md).
