Додатки
==========

Додатки це об’єкти, які керують всією структурою і життєвим циклом прикладної системи Yii.
Кожна Yii прикладна система містить у собі один об’єкт додатка, який створбється у [вхідному скрипті](structure-entry-scripts.md) 
і глобально доступний через `\Yii::$app`.

> Інформація: В залежності від контексту, коли ми говорим "додаток", це може означати як об’єкт додатка, так і прикладну систему додатка вцілому.

Існує два вида додатків: [[yii\web\Application|веб додатки]] і [[yii\console\Application|консольні додатки]].
Як можна здогадатись із назви, перший тип в основному займається обробкою веб запитів, в той час як останній - консольних команд.


## Конфігурації додатка <a name="application-configurations"></a>

Коли [вхідний скрипт](structure-entry-scripts.md створює додаток, він завантажить [конфігурацію](concept-configurations.md)
і примінить її до додатка, наприклад:

```php
require(__DIR__ . '/../vendor/autoload.php');
require(__DIR__ . '/../vendor/yiisoft/yii2/Yii.php');

// завантаження конфігурації додатка
$config = require(__DIR__ . '/../config/web.php');

// створення об’єкта додатка і його налаштування
(new yii\web\Application($config))->run();
```

Так як і звичайні [конфігурації](concept-configurations.md), конфігурації додатка вказують як слід ініціювати властивості об’єктів додатка. Через те, що конфігурації додатків часто є складними, вони розбиваються на декілька
[конфігураційних файлів](concept-configurations.md#configuration-files), наприклад, `web.php` файл в наведеному вище прикладі.


## Властивості додатків <a name="application-properties"></a>

Існує багато важливих властивостей додатка, які ви налаштовуєте в конфігураціях додатка. Ці властивості зазвичай описують середовище, в якому працює додаток. Наприклад, додаток мусить знати яким чином завантажувати [контролери](structure-controllers.md), де зберігати тимчасові файли, і т.п. Нижче ми розглянемо дані властивостей.


### Об’язкові властивості <a name="required-properties"></a>

В любому додатку, ви маєте налаштувати мінімум дві властивості: [[yii\base\Application::id|id]]
і [[yii\base\Application::basePath|basePath]].


#### [[yii\base\Application::id|id]] <a name="id"></a>

Властивість [[yii\base\Application::id|id]] це унікальний індекс додатка, який відрізняє його від решти інших додатків.
В основному це використовується всередені системи. Хоч і не є обов’язковим, але для кращої  сумістності рекомендується використовувати буквено-цифрові символи при налаштуванні індекса додатка.


#### [[yii\base\Application::basePath|basePath]] <a name="basePath"></a>

Властивість [[yii\base\Application::basePath|basePath]] вказує на кореневу директорію додатка. Ця директорія, яка містить весь код прикладної системи додатка. В цій директорії зазвичай можуть знаходитись теки `models`, `views`, `controllers`, які містять код, що відповідає шаблону проектування MVC.

Ви можете налаштувати властивість [[yii\base\Application::basePath|basePath]] вказавши прямий шлях до директорії через [псевдоніми шляху](concept-aliases.md). В обох випадках, вказана директорія має існувати, інакше буде отримано виняток. Шлях буде нормалізований за допомогою виклику функції `realpath()`.

Властивість [[yii\base\Application::basePath|basePath]] часто використовується для важливих шляхів, наприклад, шлях до runtime директоріх, котра використовується в процесі робити додатка. Саме по цій причині, псевдонім шляху `@app` є зумовленим і вказує на дану директорію. Інші шляхи можуть бути визначеними шляхом використання псевдоніму шляху, наприклад,
`@app/runtime`.


### Важливі властивості <a name="important-properties"></a>

Властивості, перелічені в даному підрозділі, частіш за все повинні бути налаштовані так як вони можуть відрізнятися в різних додатках.


#### [[yii\base\Application::aliases|aliases]] <a name="aliases"></a>

Дана властивість дозволяє налаштувати вам безліч [псевдонімів](concept-aliases.md) в рамках масива.
Ключами масива є імена псевдонімів, а ключами - відповідні значеня шляхів. Наприклад,

```php
[
    'aliases' => [
        '@name1' => 'path/to/path1',
        '@name2' => 'path/to/path2',
    ],
]
```

Ця властивість доступна таким чином, аби ви змогли вказувати псевдоніми в рамках конфігурації додатка, а не викликаючи метод [[Yii::setAlias()]].


#### [[yii\base\Application::bootstrap|bootstrap]] <a name="bootstrap"></a>


Дана властивість є дуже зручною, вона дозволяє вказувати масив компонентів, котрі мусять бути завантажені в процесі [[yii\base\Application::bootstrap()|початкового завантаження]] додатка. Наприклад, якщо ви хочете, щоб [модуль](structure-modules.md) виконував тонке налаштування [URL правил](runtime-url-handling.md), ви можете вказати його ID в якості елемента даної властивості.

Кожний з елементів даної властивості може вказуватись в одному з наступних форматів:

- ID, вказаний в [компонентах](#components);
- ID модуля, вказаний в [модулях](#modules);
- назва класа;
- масив конфігурації.

Наприклад,

```php
[
    'bootstrap' => [
        // ID компонента додатка або модуля
        'demo',

        // назва класа
        'app\components\TrafficMonitor',

        // масив конфігурації
        [
            'class' => 'app\components\Profiler',
            'level' => 3,
        ]
    ],
]
```

В процесі початкового завантаження, буде створено кожний компонент. Якщо клас компонента містить інтерфейс [[yii\base\BootstrapInterface]], то також буде викликаний метод [[yii\base\BootstrapInterface::bootstrap()|bootstrap()]].

Ще одним практичним прикладом є конфігурація [базового шаблону додатка](start-installation.md), в якій модулі `debug` і `gii` вказані як `bootstrap` компоненти, коли додаток знаходиться у відлагоджувальному режимі.

```php
if (YII_ENV_DEV) {
    // налаштування конфігурації для середовища 'dev'
    $config['bootstrap'][] = 'debug';
    $config['modules']['debug'] = 'yii\debug\Module';

    $config['bootstrap'][] = 'gii';
    $config['modules']['gii'] = 'yii\gii\Module';
}
```

> Примітка: Якщо вказувати велику кількість компонентів у `bootstrap`, то це приведе до зниження продуктивності додатка, тому що для кожного запиту буде завантажуватись однакова кількість компонентів. Таким чином ви мусите розумно використовувати початкове завантаження.


#### [[yii\web\Application::catchAll|catchAll]] <a name="catchAll"></a>

Дана властивість підтримується тільки [[yii\web\Application|веб додатками]].Вона вказує на [події контролера](structure-controllers.md), які мусять опрацьовувати всі вхідні запити від користувача. В основному це використовується коли додаток знаходиться в режимі обслуговування і мусить опрацьовувати всі запити через одну подію.

Конфігурація це масив, перший елемент якого вказує на маршрут події. Решта елементів в форматі ключ-значення вказують на додаткові параметри, які мають бути передані події. Наприклад,

```php
[
    'catchAll' => [
        'offline/notice',
        'param1' => 'value1',
        'param2' => 'value2',
    ],
]
```


#### [[yii\base\Application::components|components]] <a name="components"></a>

Дана властивість є найважливішою. Вона дозволяє вам вказати перелік компонентів під назвою [компоненти додатку](#structure-application-components.md), які ви можете використовувати в інших місцях. Наприклад,

```php
[
    'components' => [
        'cache' => [
            'class' => 'yii\caching\FileCache',
        ],
        'user' => [
            'identityClass' => 'app\models\User',
            'enableAutoLogin' => true,
        ],
    ],
]
```

Кожний компонент додатка вказаний масивом в форматі ключ-значення. Ключ являє собою ID компонента додатка, в той час як значення являє собою назву класа або [конфігурацію](concept-configurations.md).

Ви можете зареєструвати будь-який компонент в додатку, пізніше цей компонент буде доступний глобально через вираз  `\Yii::$app->ComponentID`.

Більш детальна інформація наведена в розділі [Компоненти додатка](structure-application-components.md).


#### [[yii\base\Application::controllerMap|controllerMap]] <a name="controllerMap"></a>

Дана властивість дозволяє вам встановлювати залежності між ID контролера і його класом. За замовчуванням, Yii встановлює відповідність між ID контролера і його класом згідно даної [домовленості](#controllerNamespace) (таким чином,
ID `post` буде відповідати `app\controllers\PostController` ). За допомогою налаштування даної властивості ви можете змінити домовленість для потрібних контролерів. В наведеному прикладі, `account` буде відповідати `app\controllers\UserController`, в той час як `article` буде відповідати `app\controllers\PostController`.

```php
[
    'controllerMap' => [
        [
            'account' => 'app\controllers\UserController',
            'article' => [
                'class' => 'app\controllers\PostController',
                'enableCsrfValidation' => false,
            ],
        ],
    ],
]
```

Ключами даної властивості є ID контролерів, а значенями є назва класа контролера або [конфігурація](concept-configurations.md).


#### [[yii\base\Application::controllerNamespace|controllerNamespace]] <a name="controllerNamespace"></a>

Дана властивість вказує на простір імен, де за замовчуванням мусять міститись назви класів контролерів.
За замовчуванням значення рівне `app\controllers`. Якщо ID контролера `post`, то згідно домовленості, відповідний клас контролера (без простору імен) буде рівним `PostController`, а повна назва класа буде `app\controllers\PostController`.

Клас контролера також може знаходитись в підпапці теки, що відповідає цьому простору імен. Наприклад, даному ID контролера `admin/post`, відповідає повне ім’я класа контролера `app\controllers\admin\PostController`.

Дуже важливо, щоб ім’я класа контролера могло бути використане [автозавантаженням](concept-autoloading.md) і відповідний простір імен вашого контролера відповідав даній властивості. Інакше, ви отримаєте помилку "Сторінка не знайдена", коли спробуєте отримати доступ до додатка.

У випадку, якщо ви хочете змінити домовленість яку розглянуто вище, ви можете використовувати властивість [controllerMap](#controllerMap).


#### [[yii\base\Application::language|language]] <a name="language"></a>

Дана властивість вказує на мову додатка, на якій вміст сторінки мусить бути зображений кінцевому користувачу.
За замовчуванням, значення даної властивості рівне `en`, що значить "Англійський". Якщо ваш додаток підтримує декілька мов, ви мусите налаштувати дану властивість.

Значення даної властивості визначається декількома різними аспектами [інтернаціоналізації](tutorial-i18n.md), в тому числі
перекладом повідомлень, форматуванням дат, форматуванням чисел, і т. п. Наприклад, віджет [[yii\jui\DatePicker]] використовує дану властивість для визначення мови за замовчуванням, на якій має бути зображений календар і формат даних для календаря.

Рекомендується, щоб ви вказували мову в рамках стандатра [IETF](http://en.wikipedia.org/wiki/IETF_language_tag).
Наприклад, для англійської мови використовується `en`, в той час як для англійської в США - `en-US`.

Більш детальна інформація наведена в розділі [Інтернаціоналізація](tutorial-i18n.md).


#### [[yii\base\Application::modules|modules]] <a name="modules"></a>

Дана властивість вказує на [модулі](structure-modules.md), які містяться в додатку.

Значеннями властивості можуть бути масиви імен класів модулів або [конфігурацій](concept-configurations.md), а ключами -
ID модулів. Наприклад,

```php
[
    'modules' => [
        // a "booking" module specified with the module class
        'booking' => 'app\modules\booking\BookingModule',

        // a "comment" module specified with a configuration array
        'comment' => [
            'class' => 'app\modules\comment\CommentModule',
            'db' => 'db',
        ],
    ],
]
```

Більш детальна інформація наведена в розділі [Модулі](structure-modules.md).


#### [[yii\base\Application::name|name]] <a name="name"></a>

Властивість вказує на ім’я додатка, яку может бути зображене кінцевому користувачу. На відміну від властивості [[yii\base\Application::id|id]], яка має бути унікальним, значення даної властивості потрібне в основному для відображення і не є обов’язково унікальним.

Якщо ваш код не використовує дану властивість, то ви можете не налаштовувати її.


#### [[yii\base\Application::params|params]] <a name="params"></a>

Дана властивість описує масив глобально доступних параметрів додатка. Замість того, щоб використовувати жорстко фіксовані числа і строки у вашому коді, краще оголосити їх параметрами додатка в єдиному місці і використовувати в необхідних місцях кода. Наприклад, ви можете визначити розмір прев’ю для зображеннь наступним чином:

```php
[
    'params' => [
        'thumbnail.size' => [128, 128],
    ],
]
```

Потім, коли вам потрібно використати дані значення у вашому коді, ви робите так як показано нижче:

```php
$size = \Yii::$app->params['thumbnail.size'];
$width = \Yii::$app->params['thumbnail.size'][0];
```

Якщо пізніше вам знадобиться змінити розмір прев’ю зображення, то потрібно буде змінити лише це значення в налаштуваннях додатка не торкаючись залежного коду.


#### [[yii\base\Application::sourceLanguage|sourceLanguage]] <a name="sourceLanguage"></a>

Дана властивість вказує мову на якій написаний код додатка. За замовчуванням значення рівне `'en-US'`, що значить "Англійський" (США). Ви мусите налаштувати дану властивість відповідним чином, якщо зміст у вашому коді вказаний не англійською.

Аналогічно властивості [language](#language), ви мусите вказати дану властивість в рамках стандарту [IETF](http://en.wikipedia.org/wiki/IETF_language_tag).
Наприклад, для англійської мови використовується `en`, в той час як для англійської в США - `en-US`.

Більш детальна інформація наведена в розділі [Інтернаціоналізація](tutorial-i18n.md).


#### [[yii\base\Application::timeZone|timeZone]] <a name="timeZone"></a>

Дана властивість надає альтернативний спосіб встановлення часової зони в процесі роботи додатка. Таким чином, вказуючи дану властивість, ви викликаєте PHP функцію [date_default_timezone_set()](http://www.php.net/manual/ru/function.date-default-timezone-set.php). Наприклад,

```php
[
	// Europe/Kiev для України
    'timeZone' => 'America/Los_Angeles',
]
```

#### [[yii\base\Application::version|version]] <a name="version"></a>

Дана властивість вказує на версію додатка. За замовчуванням значення рівне `'1.0'`. Ви можете не використовувати дану властивість, якщо ваш код не використовує її.


### Корисні властивості <a name="useful-properties"></a>

Властивості, які перераховані в даному розділі не є часто конфігуруємими, так як їх значення за замовчуванням відповідають загальноприйнятим домовленостям. Однак, ви можете їх налаштувати, якщо вам потрібно використовувати інші значення.


#### [[yii\base\Application::charset|charset]] <a name="charset"></a>

Властивість вказує кодування, яке використовує додаток. За замовчуванням значення рівне `'UTF-8'`, яке мусить бути залишеним для бульшості додатків, тільки якщо ви не працюєте з устарівшим кодом, який використовує більшу кількість даних не юнікода.


#### [[yii\base\Application::defaultRoute|defaultRoute]] <a name="defaultRoute"></a>

Властивість вказує [маршрут](runtime-routing.md), який мусить використовувати додаток, коли він не вказаний у вхідному запиті. Маршрут може складатись із ID модуля, ID контролера і/або ID події. Наприклад, `help`,
`post/create`, `admin/post/create`. Якщо подію не вказано, то буде використано значення за замовчуванням вказане в [[yii\base\Controller::defaultAction]].

Для [yii\web\Application|веб додатків], значення за замовчуванням даної властивості рівне `'site'`, що значить контролер `SiteController` і його подія за замовчуванням. Таким чином, якщо ви спробуєте отримати доступ до додатка не вказавши маршрут, то вам буде зображено результат події `app\controllers\SiteController::actionIndex()`.

Для [yii\console\Application|консольних додатків], значення за замовчуванням рівне `'help'`, яке означає, що мусить використовуватись вбудована команда [[yii\console\controllers\HelpController::actionIndex()]]. Таким чином, якщо ви виконаєте команду `yii` без аргументів, вам будет зображена довідкова інформація.


#### [[yii\base\Application::extensions|extensions]] <a name="extensions"></a>

Дана властивість описує перелік [розширень](structure-extensions.md), які встановлені і використовуються додатком. За замовчуванням, значення даної властивості буде масив, отриманий з файла `@vendor/yiisoft/extensions.php`. Файл `extensions.php` генерується і використовується автоматично, коли ви використовуєте [Composer](http://getcomposer.org) для встановлення розширень.
Таким чином, в більшості випадків вам не потрібно налашстовувати дану властивість.

В особливих випадках, коли ви хочете опрацьовувати розширення в ручному режимі, ви можете вказати дану властивість наступним чином:

```php
[
    'extensions' => [
        [
            'name' => 'extension name',
            'version' => 'version number',
            'bootstrap' => 'BootstrapClassName',  // опціонально, може бути також масив конфігурації
            'alias' => [  // опціонально
                '@alias1' => 'to/path1',
                '@alias2' => 'to/path2',
            ],
        ],

        // ... аналогічно для решти розширень ...

    ],
]
```

Властивість є масивом специфікацій розширень. Кожне розширення вказано масивом, який складається з елементів `name` і `version`. Якщо розширення має бути виконано в процесі [початкового завантаження](runtime-bootstrapping.md), то слід вказати `bootstrap` елемент, який може бути іменем класа або [конфігурацією](concept-configurations.md).
Розширення також може визначати декілька [псевдонімів](concept-aliases.md).


#### [[yii\base\Application::layout|layout]] <a name="layout"></a>

Дана властивість вказує ім’я шаблону за замовчуванням, який мусить бути використаний при формувані [представлення](structure-views.md).
Значення за замовчуванням рівне `'main'`, яке означає, що має бути використаний шаблон `main.php` в [директорії шаблонів](#layoutPath).
Якщо обидві властивості [директорія шаблонів](#layoutPath) і [директорія представлень](#viewPath) мають значення за замовчуванням, то файл шаблону за замовчуванням може бути представлений псевдонімом шляху як `@app/views/layouts/main.php`.

Для відключення використання шаблону, ви можете вказати дану властивість як `false`, хоча це використовується дуже рідко.


#### [[yii\base\Application::layoutPath|layoutPath]] <a name="layoutPath"></a>

Властивість вказує шлях по якому слід шукати шаблони. Значення за замовчуванням рівне `layouts`, що означає підпапку в [директорії представлень](#viewPath). Якщо значення [директорії представлень](#viewPath) є значенням за замовчуванням, то директорія шаблонів за замовчуванням може бути представлена псевдонімом шляху як `@app/views/layouts`.

Ви можете налаштувати дану властивість як теку так і як [псевдонім](concept-aliases.md).


#### [[yii\base\Application::runtimePath|runtimePath]] <a name="runtimePath"></a>

Властивість вказує шлях, по якому зберігаються тисчасові файли, такі як: лог файли, кеш файли. За замовчуванням значення рівне директорії, яка преставлена псевдонімом шляху `@app/runtime`.

Ви можете налаштувати дану властивість як директорію або як [псевдонім](concept-aliases.md) шляху. Зверніть увагу, що дана директорія має бути доступна для запису процесом, який запускає додаток. Також директорія має бути захищена від доступу кінцевим користувачам, файли які зберігаються в ній можуть містити важливу інформацію.

Для спрощення роботи з даною директорією, Yii надає зумовлений псевдонім шляху `@runtime`.


#### [[yii\base\Application::viewPath|viewPath]] <a name="viewPath"></a>

Дана властивість вказує на базову директорію, де містяться всі файли представлень. Значення за замовчуванням являє собою псевдонім `@app/views`. Ви можете налаштувати дану властивість як директорію так і [псевдонімом](concept-aliases.md).


#### [[yii\base\Application::vendorPath|vendorPath]] <a name="vendorPath"></a>

Властивість визначає директорію сторонніх бібліотек, які використовуються і керуються [Composer](http://getcomposer.org). Вона містить всі сторонні бібліотеки, які використовуються додатком, включаючи Yii фреймворк. Значеня за замовчуванням являє собою псевдонім `@app/vendor`.

Ви можете налаштувати дану властивість як директорію так і [псевдонімом](concept-aliases.md). При зміні даної властивості, переконайтесь що ви також змінили відповідним чином налаштування Composer.

Для спрощення роботи з даною директорією, Yii надає зумовлений псевдонім шляху `@vendor`.


#### [[yii\console\Application::enableCoreCommands|enableCoreCommands]] <a name="enableCoreCommands"></a>

Дана властивість підтримується тільки [[yii\console\Application|консольними додатками]]. Вона вказує чи потрібно використовувати вбудовані в Yii консольні команди. Значення за замовчуванням рівне `true`.


## Події додатка <a name="application-events"></a>

Протягом життєвого циклу додатка, виникає декілька подій. Ви можете призначати обробники подій в конфігурації додатка наступним чином:

```php
[
    'on beforeRequest' => function ($event) {
        // ...
    },
]
```

Використання синтаксису `on eventName` детально описано в розділі [Конфігурації](concept-configurations.md#configuration-format).

Також ви можете призначити обробників подій в процесі початкового [завантаження додатку](runtime-bootstrapping.md), зразу після того
як буде створено додаток. Наприклад,

```php
\Yii::$app->on(\yii\base\Application::EVENT_BEFORE_REQUEST, function ($event) {
    // ...
});
```

### [[yii\base\Application::EVENT_BEFORE_REQUEST|EVENT_BEFORE_REQUEST]] <a name="beforeRequest"></a>

Дана подія виникає *до* того як додаток починає обробляти вхідний запит. 
Справжнє ім’я події - `beforeRequest`.

На момент виникнення данох події, об’єкт додатка вже створений і проініційований. Таким чином, це є хорошим місцем для добавляння вашего коду з допомогою подій, для перехвату управління обробкою запиту.
Наприклад, обробник події, може динамічно підставляти мову додатка [[yii\base\Application::language]] в залежності від деяких параметрів.


### [[yii\base\Application::EVENT_BEFORE_REQUEST|EVENT_AFTER_REQUEST]] <a name="afterRequest"></a>

Дана подія виникає *після* того як додаток закінчує обробку запиту, але *до* того як виникне відправка відповіді. Справжнє ім’я події - `afterRequest`.

На момент виникнення даної події, обробка запиту завершена і ви можете використати це для побудови постобробки запиту, з метою налаштування відповіді.

Зверніть увагу, що в компоненті [[yii\web\Response|response]] також виникають події в процесі відправки даних кінцевому користувачу. Ці події виникають *після* поточної події.


### [[yii\base\Application::EVENT_BEFORE_REQUEST|EVENT_BEFORE_ACTION]] <a name="beforeAction"></a>

Подія виникає *до* того як буде виконано [подію контролера](structure-controllers.md). Справжнє ім’я події - `beforeAction`.

Подія є об’єктом [[yii\base\ActionEvent]]. Обробник події може встановлювати властивість [[yii\base\ActionEvent::isValid]] рівним `false` для попередження виконання події.

Наприклад,

```php
[
    'on beforeAction' => function ($event) {
        if (деяка умова) {
            $event->isValid = false;
        } else {
        }
    },
]
```

Зверніть увагу на те, що та сама подія `beforeAction` виникає в [модулях](structure-modules.md) і [контролерах](structure-controllers.md). Об’єкти додатку є першими, хто ініціює дані події, вслід за модулями (якщо такі мають місце) і в кінці контролерами. Якщо обробник події встановлює властивість [[yii\base\ActionEvent::isValid]] рівним `false`, то всі наступні події не виникнуть.


### [[yii\base\Application::EVENT_BEFORE_REQUEST|EVENT_AFTER_ACTION]] <a name="afterAction"></a>

Подія виникає *після* виконання [події контролера](structure-controllers.md).
Справжнє ім’я події - `afterAction`.

Подія є об’єктом [[yii\base\ActionEvent]]. Через властивість [[yii\base\ActionEvent::result]] обробник події може отримати доступ і змінити значення виконання події контролера.

Наприклад,

```php
[
    'on afterAction' => function ($event) {
        if (деяка умова) {
            // modify $event->result
        } else {
        }
    },
]
```

Зверніть увагу, що ті ж самі події `afterAction` виникають в [модулях](structure-modules.md) і [контролерах](structure-controllers.md). Ці об’єкти ініціюють подіх у зворотньому порядку, якщо зрівнювати з `beforeAction`.
Таким чином, контролеры є першими, де виникає дана подія, потім в модулях (якщо такі мають місце), і врешті в додатках.


## Життєвий цикл додатка <a name="application-lifecycle"></a>

Коли [вхідний скрипт](structure-entry-scripts.md) виконується для обробки запиту, додаток буде розвиватись згідно наступного життєвого циклу:

1. Вхідний скрипт завантажує конфігурацію додатка в якості масива;
2. Вхідний скрипт створює новий об’єкт додатка:
  * Викликається метод [[yii\base\Application::preInit()|preInit()]], який налаштовує деякі життєво важливі властивості додатка, такі як [[yii\base\Application::basePath|basePath]];
  * Реєструється [[yii\base\Application::errorHandler|обробник помилок]];
  * Налаштовуються властивості додатку;
  * Викликається метод [[yii\base\Application::init()|init()]], котрий потім викликає метод [[yii\base\Application::bootstrap()|bootstrap()]] для початкового завантаження компонентів.
3. Вхідний скрипт викликає метод [[yii\base\Application::run()]] для запуску додатка:
  * Виникає подія [[yii\base\Application::EVENT_BEFORE_REQUEST|EVENT_BEFORE_REQUEST]];
  * Обробка запиту: розбір інформації запиту в [маршруті](runtime-routing.md) з відповідними параметрами;
    створення об’єктів модуля, контролера і події згідно вказаного маршруту; запуск подій;
  * Виникає подія [[yii\base\Application::EVENT_AFTER_REQUEST|EVENT_AFTER_REQUEST]];
  * Відповідь надсилається кінцевому користувачу.
4. Вхідний скрипт отримує значення статусу виходу з додатка і завершує обробку запиту.
