Database Fixtures
=================

Fixtures are important part of testing. Their main purpose is to populate you with data that needed by testing
different cases. With this data using your tests becoming more efficient and useful.

Yii supports database fixtures via the `yii fixture` command line tool. This tool supports:

* Applying new fixtures to database tables;
* Clearing, database tables (with sequences);
* Auto-generating fixtures and populating it with random data.

Fixtures format
---------------

Fixtures are just plain php files returning array. These files are usually stored under `@tests/unit/fixtures` path, but it
can be [configured](#configure-command-globally) in other way. Example of fixture file:

```
#users.php file under fixtures path

return [
	[
		'name' => 'Chase',
		'login' => 'lmayert',
		'email' => 'strosin.vernice@jerde.com',
		'auth_key' => 'K3nF70it7tzNsHddEiq0BZ0i-OU8S3xV',
		'password' => '$2y$13$WSyE5hHsG1rWN2jV8LRHzubilrCLI5Ev/iK0r3jRuwQEs2ldRu.a2',
	],
	[
		'name' => 'Celestine',
		'login' => 'napoleon69',
		'email' => 'aileen.barton@heaneyschumm.com',
		'auth_key' => 'dZlXsVnIDgIzFgX4EduAqkEPuphhOh9q',
		'password' => '$2y$13$kkgpvJ8lnjKo8RuoR30ay.RjDf15bMcHIF7Vz1zz/6viYG5xJExU6',
	],
];
```

This data will be loaded to the `users`, but before it will be loaded table `users` will be cleared: all data deleted, sequence reseted.
Above fixture example was auto-generated by `yii2-faker` extension, read more about it in these [section](#auto-generating-fixtures).

Applying fixtures
-----------------

To apply fixture to the table, run the following command:

```
yii fixture/apply <tbl_name>
```

The required `tbl_name` parameter specifies a database table to which data will be loaded. You can load data to several tables at once.
Below are correct formats of this command:

```
// apply fixtures to the "users" table of database
yii fixture/apply users

// same as above, because default action of "fixture" command is "apply"
yii fixture users

// apply several fixtures to several tables. Note that there should not be any whitespace between ",", it should be one string.
yii fixture users,users_profiles

// apply all fixtures
yii fixture/apply all

// same as above
yii fixture all

// apply fixtures to the table users, but fixtures will be taken from different path.
yii fixture users --fixturePath='@app/my/custom/path/to/fixtures'

// apply fixtures to the table users, but for other database connection.
yii fixtures users --db='customDbConnectionId'
```

Clearing tables
---------------

To clear table, run the following command:

```
// clear given table: delete all data and reset sequence.
yii fixture/clear users

// clear several tables. Note that there should not be any whitespace between ",", it should be one string.
yii fixture/clear users,users_profile

// clear all tables of current connection in current schema
yii fixture/clear all
```

Configure Command Globally
--------------------------
While command line options allow us to configure the migration command
on-the-fly, sometimes we may want to configure the command once for all. For example you can configure
different migration path as follows:

```
'controllerMap' => [
    'fixture' => [
        'class' => 'yii\console\FixtureController',
        'fixturePath' => '@app/my/custom/path/to/fixtures',
		'db' => 'customDbConnectionId',
    ],
]
```

Auto-generating fixtures
------------------------

Yii also can auto-generate fixtures for you based on some template. You can generate your fixtures with different data on different languages and formats.
These feature is done by [Faker](https://github.com/fzaninotto/Faker) library and `yii2-faker` extension.
See extension [guide](https://github.com/yiisoft/yii2/tree/master/extensions/yii/faker) for more docs.
