<?php

Route::get('/', function () {
    return view('index');
});

Route::group(['middleware' => 'visitors'], function()
{
    Route::get('/register', 'RegistrationController@register');
    Route::post('/register', 'RegistrationController@postRegister');
    Route::get('/login', 'LoginController@login');
    Route::post('/login', 'LoginController@postLogin');
    Route::get('/forgot-password', 'ForgotPasswordController@forgotPassword');
    Route::post('/forgot-password', 'ForgotPasswordController@postForgotPassword');
    Route::get('/reset/{email}/{resetCode}', 'ForgotPasswordController@resetPassword');
});

Route::post('/logout', 'LoginController@logout');

Route::group(['middleware' => 'manager'], function()
{
    Route::get('/manager', 'ManagerController@index');
    Route::get('/penjualan', 'ManagerController@penjualan');
    Route::get('/viewpengunjung', 'ManagerController@pengunjung');
    Route::get('/viewfeedback', 'ManagerController@viewFeedback');
    Route::get('/gantipassword', 'ManagerController@changePassword');
    Route::put('/gantipassword', 'ManagerController@changePasswordPost');
});

Route::group(['middleware' => 'staff'], function ()
{
    Route::get('/staff', 'StaffController@index');
    Route::get('/pemesanan', 'TicketController@datapesanan');
    Route::get('/lunas/{id}','TicketController@lunas');
    Route::get('/pemesanan/destroy/{id}', 'TicketController@destroypemesanan');
    Route::get('/data_transaksi','TicketController@datatransaksi');
    Route::get('/pengunjung', 'StaffController@pengunjung');
    Route::post('/pengunjung/store', 'StaffController@storepengunjung');
    Route::get('/member', 'StaffController@viewMember');
    Route::get('/changepassword', 'StaffController@changePassword');
    Route::put('/changepassword', 'StaffController@changePasswordPost');
});

Route::group(['middleware' => 'customer'], function ()
{
    Route::get('/customer', 'CustomerController@index');
    Route::resource('/ticket', 'TicketController');
    Route::get('/ticket/beli/{id}','TicketController@beli');
    Route::post('/ticket/beli','TicketController@storeorder');
    Route::get('/order/{id}','TicketController@done');
    Route::resource('/data_order','TicketController@dataorder');
    Route::get('/data_order/destroy/{id}', 'TicketController@destroyorder');
    Route::get('/data_order/upload/{id}', 'TicketController@upload');
    Route::put('/data_order/upload/{id}', 'TicketController@update');
    Route::get('/data_konfirmasi','TicketController@datakonfirmasi');
    Route::get('/feedback', 'CustomerController@feedbackIndex');
    Route::post('/feedback/create', 'CustomerController@createFeedback');
    Route::get('/password', 'CustomerController@changePassword');
    Route::put('/password', 'CustomerController@changePasswordPost');
});
