@if(Sentinel::check())
@extends('layouts.master-manager')
@section('content')

    <div class="right_col" role="main">
        <div class="">
            <div class="page-title">
                <div class="title_left">
                    <h4> <a href="{{url('/staff')}}" class="fa fa-home"> Home</a> / <a href="{{url('/changepassword')}}"> Change Password</a> </h4>
                </div>
            </div>

            <div class="clearfix"></div>
            <div class="row">
                <div class="col-md-12 col-sm-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>Change Password </h2>
                            <div class="clearfix"></div>
                        </div>


                        <div class="x_content">
                            @if(Session::has('alert-success'))
                                <div class="alert alert-success">
                                    {{ Session::get('alert-success') }}
                                </div>
                            @endif
                            <form class="form-horizontal" role="form" method="POST" action="{{ url('/changepassword') }}">

                                {{ csrf_field() }}
                                {{ method_field('put') }}

                                <div class="form-group{{ $errors->has('current_password') ? ' has-error' : '' }}">
                                    <label for="current_password" class="col-md-4 control-label">Current Password</label>

                                    <div class="col-md-6">
                                        <input id="current_password" type="password" class="form-control" name="current_password" autofocus>
                                        <span class="help-block">{{ $errors->first('current_password') }}</span>
                                    </div>
                                </div>

                                <div class="form-group{{ $errors->has('password') ? ' has-error' : '' }}">
                                    <label for="password" class="col-md-4 control-label">New Password</label>

                                    <div class="col-md-6">
                                        <input id="password" type="password" class="form-control" name="password">
                                        <span class="help-block">{{ $errors->first('password') }}</span>
                                    </div>
                                </div>

                                <div class="form-group{{ $errors->has('password_confirmation') ? ' has-error' : '' }}">
                                    <label for="password_confirmation" class="col-md-4 control-label">New Password Confirmation</label>

                                    <div class="col-md-6">
                                        <input id="password_confirmation" type="password" class="form-control" name="password_confirmation">
                                        <span class="help-block">{{ $errors->first('password_confirmation') }}</span>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="col-md-8 col-md-offset-4">
                                        <button type="submit" class="btn btn-primary">
                                            Change Password
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@endif