@if(Sentinel::check())
@extends('layouts.master-customer')

@section('content')

<!-- page content -->
<div class="right_col" role="main">
    <div class="">
        <div class="page-title">
            <div class="title_left">
                <h4> <a href="{{url('/customer')}}" class="fa fa-home"> Home</a> / <a href="{{url('/ticket')}}"> Order Ticket</a> </h4>
            </div>

        </div>

        <div class="clearfix"></div>

        <div class="row">

            <div class="col-md-12 col-sm-12 col-xs-12">
                <div class="x_panel">
                    <div class="x_title">
                        <h2>Order Tiket</h2>
                        <div class="clearfix"></div>
                    </div>
                    <div class="x_content">

                        @if(Session::has('alert-success'))
                            <div class="alert alert-success">
                                {{ Session::get('alert-success') }}
                            </div>
                        @endif

                        <!-- price element -->
                        <div class="col-md-4 col-sm-6 col-xs-12" style="align-content: center">

                        </div>
                        <!-- price element -->

                            <!-- price element -->
                            <div class="col-md-4 col-sm-6 col-xs-12" style="align-content: center">
                                <div class="pricing ui-ribbon-container">
                                    <div class="ui-ribbon-wrapper">
                                        <div class="ui-ribbon">
                                            Available
                                        </div>
                                    </div>
                                    @foreach($tickets as $ticket)
                                        <div class="title">
                                            <h2>{{$ticket->name}}</h2>
                                            <h1>IDR{{$ticket->price}}</h1>
                                            <span>Once</span>
                                        </div>
                                        <div class="x_content">
                                            <div class="">
                                                <div class="pricing_features">
                                                    <ul class="list-unstyled text-left">
                                                        <img src="{{ asset('image/'. $ticket->images) }}" style="height: 100%; width: 100%; ">
                                                        <li><i class="fa fa-check text-success"></i> One day enjoy<strong> in museum</strong></li>
                                                    </ul>
                                                </div>
                                            </div>
                                            <div class="pricing_footer">
                                                <form method="POST" action="{{ route('ticket.store', $ticket->id) }}" accept-charset="UTF-8">
                                                    <a href="{{url('/ticket/beli',$ticket->id)}}" class="btn btn-primary btn-block" >Order Now</a>
                                                </form>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                            <!-- price element -->

                            <!-- price element -->
                            <div class="col-md-4 col-sm-6 col-xs-12" style="align-content: center">

                            </div>
                            <!-- price element -->

                        {{--<a href="{{route('ticket.create')}}" class="btn btn-info pull-right">Add New Menu</a><br><br>--}}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- /page content -->
@endsection
@endif