@if(Sentinel::check())
@extends('layouts.master-customer')
@section('content')
<!-- page content -->
<div class="right_col" role="main">
    <div class="">
        <div class="page-title">
            <div class="title_left">
                <h4> <a href="{{url('/customer')}}" class="fa fa-home"> Home</a> / <a href="{{url('/data_order')}}"> Data Pemesanan Tiket</a> </h4>
            </div>
        </div>

        <div class="clearfix"></div>
        <div class="row">
            <div class="col-md-12 col-sm-12 col-xs-12">
                <div class="x_panel">
                    <div class="x_title">
                        <h2>Hint</h2>
                        <div class="clearfix"></div>
                    </div>
                    <div class="x_content">
                        <h2>
                            <ul>
                                <li>
                                    Pesan tiket terlebih dahulu. Pembayaran tiket dilakukan melalui via transfer bank ke nomor Rekening 111-111-111 <br>(Bank ABC)
                                    a.n. Museum TB Silalahi Center.
                                </li>
                                <li>
                                    Foto atau screenshot bukti pembayaran.
                                </li>
                                <li>
                                    Upload bukti pembayaran melalui tombol upload yang tersedia untuk dikonfirmasi.
                                </li>
                                <li>
                                    Tombol Cancel untuk membatalkan pemesanan.
                                </li>
                            </ul>
                        </h2>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12 col-sm-12 col-xs-12">
                <div class="x_panel">
                    <div class="x_title">
                        <h2>Data Pemesanan tiket <small>Upload resi pembayaran</small></h2>

                        <div class="clearfix"></div>
                    </div>
                    <div class="x_content">
                        @if(Session::has('alert-success'))
                            <div class="alert alert-danger">
                                {{ Session::get('alert-success') }}
                            </div>
                        @endif
                        <table class="table table-hover">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>Ticket</th>
                                <th>Tanggal berkunjung</th>
                                <th>Jumlah</th>
                                <th>Harga</th>
                                <th>Resi Pembayaran</th>
                                <th>Action</th>
                                <th>Status</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $no=1; ?>
                            @foreach($orders as $order)
                                <tr>
                                    <td>{{$no++}}</td>
                                    <td>{{$order->nama}}</td>
                                    <td>{{$order->tanggal_kunjung}}</td>
                                    <td>{{$order->jumlah}}</td>
                                    <td>IDR {{$order->harga}},-</td>
                                    <td><img src="{{ asset('image/'. $order->images) }}" style="height: 150px; width: 200px; "> </td>
                                    <td>
                                        <a href="{{url('data_order/upload', $order->id)}}" class="btn btn-primary">Upload Resi Pembayaran</a>
                                        <a href="{{url('/data_order/destroy',$order->id)}}" class="btn btn-danger"
                                           onclick="return confirm('Are you sure to cancel order??')">Cancel</a>
                                    </td>
                                    <td><p style="font-size: 12pt; color: red"><b>Belum Dikonfirmasi</b></p></td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- /page content -->
@endsection
@endif