@if(Sentinel::check())
@extends('layouts.master-customer')
@section('content')
<!-- page content -->
<div class="right_col" role="main">
    <div class="">
        <div class="page-title">
            <div class="title_left">
                <h4><a href="{{url('/customer')}}" class="fa fa-home"> Home</a> / <a href="#"> Beli</a></h4>
            </div>
        </div>

        <div class="clearfix"></div>
        <div class="row">
            <div class="col-md-6 col-sm-12 col-xs-12">
                <div class="x_panel">
                    <div class="x_title">
                        <h2>Jumlah Pesanan tiket tersedia <b>"{{$tickets->name}}"</b></h2>
                        <div class="clearfix"></div>
                    </div>
                    <div class="x_content">

                        <form action="{{url('/ticket/beli/')}}" method="post">
                            {{ csrf_field() }}

                            <label class="col-md-4 control-label">User ID</label>
                            <input type="text" value="{{Sentinel::getUser()->id}}" class="form-control" name="user_id" readonly>
                            <label class="col-md-4 control-label">Name</label>
                            <input type="text" value="{{Sentinel::getUser()->first_name}}" class="form-control" name="first_name" readonly>
                            <label class="col-md-4 control-label">Ticket</label>
                            <input type="text" value="{{$tickets->name}}" class="form-control" name="nama_ticket" readonly>
                            <label class="col-md-4 control-label">Harga / ticket (IDR)</label>
                            <input type="number" value="{{$tickets->price}}" class="form-control" name="harga" readonly>
                            <label class="col-md-4 control-label">Tanggal berkunjung</label>
                            <input type="date" class="form-control" name="tanggal_kunjung">
                            <label class="col-md-4 control-label">Jumlah</label>
                            <input type="number" onkeyup="Harga(this.value)" min="1" class="form-control" name="jumlah" placeholder="masukkan jumlah tiket yang ingin dipesan" required>
                            <label class="col-md-4 control-label">Total Harga (IDR)</label><br>
                            <span class="form-control" id="total" readonly></span><br>
                            <button type="submit" class="btn btn-primary" onclick="return confirm('Continue Order??')">Order</button>
                        </form>
                        <script>function Harga(str)
                            {
                                document.getElementById("total").innerHTML = str*{{$tickets->price}};
                                return;
                            }
                        </script>
                    </div>
                </div>
            </div>

            <div class="col-md-6 col-sm-12 col-xs-12">
                <div class="x_panel">
                    <div class="x_title">
                        <h2>Keterangan</h2>
                        <div class="clearfix"></div>
                    </div>
                    <div class="x_content">
                        <h2> Tiket yang tersedia saat ini adalah Tiket Umum</h2>
                        <h2>Dengan harga IDR10000 untuk satu tiket.</h2>
                        <h2>Satu tiket berlaku untuk 1 orang.</h2>
                        <h2>Dengan 1 tiket, Anda dapat menikmati fasilitas Museum TB Silalahi Center dalam 1 hari</h2>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- /page content -->
@endsection
@endif