@extends('layouts.masterlog')
@section('body')
<body class="login">
    <div>
        <div class="login_wrapper">
            <section class="login_content">
                <form action="{{url('/register')}}" method="POST">
                    <h1>Create Account</h1>
                    @if (count($errors)>0)
                        <div class="alert alert-danger">
                            <ul>
                                @foreach($errors->all() as $error)
                                    <li>
                                        {{$error}}
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    {{csrf_field()}}

                    <div>
                        <input type="text" name="first_name" class="form-control" placeholder="First Name" required="" />
                    </div>

                    <div>
                        <input type="text" name="last_name" class="form-control" placeholder="Last Name" required="" />
                    </div>

                    <div>
                        <input type="email" name="email" class="form-control" placeholder="email@email.com" required="" />
                    </div>
                    <div>
                        <input type="password" name="password" class="form-control" placeholder="Password" required="required">
                    </div>

                    <div>
                        <input type="password" name="password_confirmation" class="form-control" placeholder="Password Confirmation" required="required">
                    </div>

                    <div class="form-group">
                        <input type="submit" value="Register" class="btn btn-success pull-right" >
                    </div>

                    <div class="clearfix"></div>

                    <div class="separator">
                        <p class="change_link">Already a member ?
                            <a href="{{url('/login')}}" class="to_register"> Log in </a>
                        </p>

                        <div class="clearfix"></div>
                        <br />

                        <div>
                            <a href="{{url('/')}}"><h1><i class="fa fa-paw"></i> TB Silalahi Center</h1></a>
                            <p>Copyright © 2017 TB Silalahi Center. All Rights Reserved.</p>
                        </div>
                    </div>
                </form>
            </section>
        </div>
    </div>
</body>
@endsection

