@extends('layouts.masterlog')

@section('body')

<body class="login">
    <div>
        <div class="login_wrapper">
            <div class="animate form login_form">
                <section class="login_content">
                    <form action="{{url('/login')}}" method="POST">
                        {{csrf_field()}}

                        <h1>Login Form</h1>

                        @if(Session::has('alert-success'))
                            <div class="alert alert-success">
                                {{ Session::get('alert-success') }}
                            </div>
                        @endif
                        @if (session('error'))
                            <div class="alert alert-danger">
                                {{ session('error') }}
                            </div>
                        @endif

                        <div>
                            <input type="email" name="email" class="form-control" placeholder="example@example.com" required="" />
                        </div>
                        <div>
                            <input type="password" name="password" class="form-control" placeholder="password" required>
                        </div>
                        <div>
                            <div class="form-group">
                                <input type="submit" value="Login" class="btn btn-default btn-success pull-right" >
                            </div>
                            {{--<a href="/forgot-password">Forgot your password?</a>--}}
                        </div>

                        <div class="clearfix"></div>

                        <div class="separator">
                            <p class="change_link">New to site?
                                <a href="{{url('/register')}}" class="to_register"> Create Account </a>
                            </p>

                            <div class="clearfix"></div>
                            <br />

                            <div>
                                <a href="{{url('/')}}"><h1><i class="fa fa-paw"></i> TB Silalahi Center</h1></a>
                                <p>Copyright © 2017 TB Silalahi Center. All Rights Reserved.</p>
                            </div>
                        </div>
                    </form>
                </section>
            </div>
        </div>
    </div>
</body>
@endsection
