<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Sentinel;
use DB;
use App\Pengunjung;
use App\User;
use Hash;
use Validator;

class StaffController extends Controller
{
    public function index()
    {
        return view('staffs.staff_home');
    }

    public function pengunjung()
    {
        $pengunjungs = Pengunjung::all();
        return view('staffs.pengunjung', compact('pengunjungs'));
    }

    public function storepengunjung(Request $request)
    {
        $pengunjungs = new Pengunjung();
        $pengunjungs->nama_pengunjung = $request->nama_pengunjung;
        $pengunjungs->jumlah = $request->jumlah;
        $harga = 10000;
        $jumlah = $request ->jumlah;
        $total = $harga * $jumlah;
        $pengunjungs->total_harga = $total;
        $pengunjungs->save();
        return redirect('pengunjung')->with('alert-success', 'Data Pengunjung tersimpan');
    }

    public function viewMember()
    {
        $members = Sentinel::findRoleBySlug('customer');
        $members = DB::table('users')->orderby('id', 'desc')->get();
        return view('staffs.daftar_member', compact('members'));
    }


    public function changePassword()
    {
        return view('staffs.profile.changepassword');
    }

    public function changePasswordPost()
    {
        // custom validator
        Validator::extend('password', function ($attribute, $value, $parameters, $validator) {
            return Hash::check($value, \Sentinel::getUser()->password);
        });

        // message for custom validation
        $messages = [
            'password' => 'Invalid current password.',
        ];

        // validate form
        $validator = Validator::make(request()->all(), [
            'current_password'      => 'required|password',
            'password'              => 'required|min:6|confirmed',
            'password_confirmation' => 'required',

        ], $messages);

        // if validation fails
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors());
        }

        // update password
        $user = User::find(Sentinel::getUser()->id);

        $user->password = bcrypt(request('password'));
        $user->save();

        return redirect()->back()->with('alert-success', 'Password telah diperbaharui.');
    }

}
