<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use App\User;
use Sentinel;
use Validator;
use Hash;

class ManagerController extends Controller
{
    public function index()
    {
        return view('managers.manager_home');
    }

    public function penjualan()
    {
        $transactions = DB::table('transactions')->orderby('id','desc')->get();
        return view('managers.data_penjualan', compact('transactions'));
    }

    public function pengunjung()
    {
        $pengunjungs = DB::table('pengunjungs')->orderby('id','desc')->get();
        return view('managers.pengunjung', compact('pengunjungs'));
    }

    public function viewFeedback()
    {
        $feedbacks = DB::table('feedback')->orderby('id','desc')->get();
        return view('managers.daftar_feedback', compact('feedbacks'));
    }

    public function changePassword()
    {
        return view('managers.profile.changepassword');
    }

    public function changePasswordPost()
    {
        // custom validator
        Validator::extend('password', function ($attribute, $value, $parameters, $validator) {
            return Hash::check($value, \Sentinel::getUser()->password);
        });

        // message for custom validation
        $messages = [
            'password' => 'Invalid current password.',
        ];

        // validate form
        $validator = Validator::make(request()->all(), [
            'current_password'      => 'required|password',
            'password'              => 'required|min:6|confirmed',
            'password_confirmation' => 'required',

        ], $messages);

        // if validation fails
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors());
        }

        // update password
        $user = User::find(Sentinel::getUser()->id);

        $user->password = bcrypt(request('password'));
        $user->save();

        return redirect()->back()->with('alert-success', 'Password telah diperbaharui.');
    }
}
