<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Sentinel;
use Cartalyst\Sentinel\Checkpoints\ThrottlingException;

class LoginController extends Controller
{
    public function login()
    {
        return view('authentication.login');
    }

    public function  postLogin(Request $request)
    {
        try{
            if(Sentinel::authenticate($request->all())){
                $slug = Sentinel::getUser()->roles()->first()->slug;

                if ($slug == 'manager')
                    return redirect('/manager');
                elseif ($slug == 'staff')
                    return redirect('/staff');
                elseif ($slug == 'customer')
                    return redirect('/customer');
            }else{
                return redirect()->back()->with(['error' => 'Wrong Credentials.']);
            }
        } catch(ThrottlingException $e) {
            $delay = $e->getDelay();

            return redirect()->back()->with(['error' => "You are banned for $delay seconds."]);
        }
    }

    public function logout()
    {
        Sentinel::logout();
            return redirect('/login');
    }
}
