<?php

namespace App\Http\Controllers;

use App\Feedback;
use Illuminate\Http\Request;
use Sentinel;
use App\User;
use DB;
use Hash;
use Validator;



class CustomerController extends Controller
{
    public function __construct()
    {

    }

    public function index()
    {
        return view('customers.customer_home');
    }

    public function feedbackIndex()
    {
        $feedbacks = Feedback::all();
        return view('customers.feedback', compact('feedbacks'));
    }

    public function createFeedback(Request $request)
    {
        $feedbacks = new Feedback();
        $feedbacks -> user_id = $request->user_id;
        $feedbacks -> first_name = $request->first_name;
        $feedbacks -> subjects = $request->subjects;
        $feedbacks -> description = $request->description;
        $feedbacks -> save();
        return redirect()-> back()->with('alert-success', 'Terima kasih atas partisipasi anda untuk memberikan feedback kepada kami');
    }

    public function changePassword()
    {
        return view('customers.profile.changepassword');
    }

    public function changePasswordPost()
    {
        // custom validator
        Validator::extend('password', function ($attribute, $value, $parameters, $validator) {
            return Hash::check($value, \Sentinel::getUser()->password);
        });

        // message for custom validation
        $messages = [
            'password' => 'Invalid current password.',
        ];

        // validate form
        $validator = Validator::make(request()->all(), [
            'current_password'      => 'required|password',
            'password'              => 'required|min:6|confirmed',
            'password_confirmation' => 'required',

        ], $messages);

        // if validation fails
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors());
        }

        // update password
        $user = User::find(Sentinel::getUser()->id);

        $user->password = bcrypt(request('password'));
        $user->save();

        return redirect()->back()->with('alert-success', 'Password telah diperbaharui.');
    }


}