@extends('layout')
@section('title')
    search
@endsection

@section('content')
    <section>
        <h2>Daftar Client</h2>
        {{--Cek jika user sudah ada. Jika tidak ada
            maka kolom tidak akan ditampilkan
        --}}
        @if(count($user))
            <table border="1">
                <thead>
                <th>ID</th>
                <th>Image</th>
                <th>Full Name</th>
                <th>Sex</th>
                <th>Identity Card</th>
                <th>Birth Date</th>
                <th>Province</th>
                <th>District</th>
                <th>Sector</th>
                <th>Cellar</th>
                <th>Option</th>
                </thead>
                <tbody>
                @foreach($user as $u)
                    <tr>
                        <td>{{$u->id}}</td>
                        <td><img src="img/{{$u->image}}" alt="{{$u->image}}" style="width:100px;height:100px;"></td>
                        <td>{{$u->fullName}}</td>
                        <td>{{$u->sex}}</td>
                        <td>{{$u->identityCard}}</td>
                        <td>{{$u->birthDate}}</td>
                        <td>{{$u->privince}}</td>
                        <td>{{$u->district}}</td>
                        <td>{{$u->sector}}</td>
                        <td>{{$u->cellar}}</td>
                        <td>
                            <form action="{{'user/'.$u->id.'/edit'}}" method="">
                                <button type="submit">Edit</button>
                            </form>

                            <form action="{{url('user/'.$u->id)}}" method="post">
                                {{ csrf_field() }}
                                <input type="hidden" name="_method" value="DELETE">
                                <button type="submit">Delete</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
                </tbody>

            </table>
        @else
            <h4>User belum ada yang terdaftar</h4>
        @endif
    </section>


@endsection
