<?php

namespace App\Http\Controllers;

use Illuminate\Database\QueryException;
use Illuminate\Http\Request;

use App\User;
use Illuminate\Support\Facades\Input;

class UserController extends Controller
{
    public function index()
    {
        $users = User::all();
        return view('pages.daftarUser')->with('users', $users);
    }

    public function create()
    {
        return view('pages.create_user');
    }
    public function store(Request $request)
    {

        try {
            User::create($request->all());
            return redirect('/');
        }
        catch (QueryException $a)
        {
            return view('pages.errorInput');
        }
    }

    public function edit($id)
    {
        $user = User::find($id);
        return view('pages.edit_user')->with('user', $user);
    }

    public function show($fullName)
    {
        $searchterm = Input::get('searchinput');
        //return view('pages.search_result')->with('user', $users);
    }

    public function update(Request $request, $id)
    {
        User::find($id)->update($request->all());
        return redirect('user');
    }

    public function destroy($id)
    {
        User::find($id)->delete();
        return redirect('user');
    }
}
