@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row">
        <div class="col-md-12 col-md-offset-0">
            <div class="panel panel-default">
                <div class="panel-heading">Data Person</div>
                    @if(Session::has('message'))
                        <div class="alert alert-success">
                            {{Session::get('message')}}
                        </div>
                    @endif
                <div class="panel-body">
                {{link_to_route('data_person.create', 'Add New Person',null,['class'=>'btn btn-primary'])}}
                <table class="table">
                <tr>
                    <th>ID</th>
                    <th>Image</th>
                    <th>Full Names</th>
                    <th>Sex</th>
                    <th>Identity Card</th>
                    <th>Birth Date</th>
                    <th>Province</th>
                    <th>District</th>
                    <th>Sector</th>
                    <th>Cellar</th>
                    <th>Action</th>
                </tr>
                    @foreach($data_persons as $data_person)
                    <tr>
                        <td>{{$data_person->id}}</td>
                        <td><img src="{{$data_person->imageurl}}" alt="can't open image"></td>
                        <td>{{$data_person->fullnames}}</td>
                        <td>{{$data_person->sex}}</td>
                        <td>{{$data_person->identitycard}}</td>
                        <td>{{$data_person->birthdate}}</td>
                        <td>{{$data_person->province}}</td>
                        <td>{{$data_person->district}}</td>
                        <td>{{$data_person->sector}}</td>
                        <td>{{$data_person->cellar}}</td>
                        <td>
                        
                        {!! Form::open(array('route'=>['data_person.destroy',$data_person->id],'method'=>'DELETE')) !!}
                            {{link_to_route('data_person.edit', 'Edit',[$data_person->id],['class'=>'btn btn-primary'])}}
                            {!! Form::button('delete',['class'=>'btn btn-danger','type'=>'submit']) !!}
                        {!! Form::close() !!}
                        </td>
                    </tr>
                    @endforeach
                </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
