<?php
defined('BASEPATH') or exit('No direct script access allowed');

class auth extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library('form_validation');
    }
    public function index()
    {

        if ($this->input->post() && ($this->input->post('captcha') == $this->session->userdata('mycaptcha'))) {
            $this->_login();
        } else {
            $path = './assets/captcha/';
            $vals = array(
                'img_path'     => $path,
                'img_url'     => base_url() . 'assets/captcha/',
                'img_width'     => '200',
                'img_height' => 30,
                'border' => 0,
                'expiration' => 7200
            );

            // create captcha image
            $cap = create_captcha($vals);

            // store image html code in a variable
            $data['image'] = $cap['image'];

            // store the captcha word in a session
            $this->session->set_userdata('mycaptcha', $cap['word']);
        }

        $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');
        $this->form_validation->set_rules('password', 'Password', 'trim|required');
        $this->form_validation->set_rules('captcha', 'Captcha', 'required');

        //validasi
        if ($this->form_validation->run() == false) {
            $data['title'] = 'Login';
            $this->load->view('templates/auth_header', $data);
            $this->load->view('auth/login');
            $this->load->view('templates/auth_footer');
        } else {
            $this->_login();
        }
    }
    private function _login()
    {
        $email = $this->input->post('email');
        $password = $this->input->post('password');
        $post_captcha = $this->input->post('captcha');
        $captcha = $this->session->userdata('mycaptcha');

        $user = $this->db->get_where('users', ['email' => $email])->row_array();
        if ($user != NULL) {
            if (password_verify($password, $user['password'])) {
                if ($this->session->userdata('mycaptcha') == true) {
                    if ($post_captcha == $captcha) {

                        $data = [
                            'email' => $user['email'],
                            'role_id' => $user['role_id']
                        ];
                        $this->session->set_userdata($data);
                        if ($user['role_id'] == 1) {
                            redirect('Admin');
                        } else {
                            echo 'INI HALAMAN USER BUATAN SI PAHALA, SOON';
                        }
                    } else {
                        $this->session->set_flashdata('captcha', '<div class="row mt-3">
                    <div class="col-md-12">
                        <div class="alert alert-danger" role="alert">
                            Captcha salah!
                        </div>
                    </div>
                    </div>
                    </div>');
                        redirect('auth');
                    }
                } else {
                    echo 'Captcha salah';
                }
            } else {
                $this->session->set_flashdata('password', '<div class="row mt-3">
                    <div class="col-md-12">
                        <div class="alert alert-danger" role="alert">
                            Password salah!
                        </div>
                    </div>
                    </div>
                    </div>');
                redirect('auth');
            }
        } else {
            $this->session->set_flashdata('aktif', '<div class="row mt-3">
                <div class="col-md-12">
                    <div class="alert alert-danger" role="alert">
                        Email belum Aktif!
                    </div>
                </div>
                </div>
                </div>');
            redirect('auth');
        }
    }
    public function registrasi()
    {
        //validasi
        $this->form_validation->set_rules('username', 'Username', 'required|trim');
        $this->form_validation->set_rules('phone', 'Phone', 'required|trim');
        $this->form_validation->set_rules('tanggal', 'Tanggal lahir', 'required|trim');
        $this->form_validation->set_rules('alamat', 'Alamat', 'required');
        $this->form_validation->set_rules('kota', 'Kota', 'required|trim');
        $this->form_validation->set_rules('password', 'Password', 'required|trim|min_length[3]|matches[confirm_password]');
        $this->form_validation->set_rules('confirm_password', 'Confirm Password', 'required|trim|min_length[3]|matches[password]');
        $this->form_validation->set_rules('email', 'Email', 'required|trim|valid_email|is_unique[users.email]', ['is_unique' => 'Email ini sudah pernah dipakai!']);

        if ($this->form_validation->run() == false) {
            $data['title'] = 'Registrasi';
            $this->load->view('templates/auth_header', $data);
            $this->load->view('auth/registrasi');
            $this->load->view('templates/auth_footer');
        } else {
            $data = [
                'username' => $this->input->post('username', true),
                'password' => password_hash($this->input->post('password'), PASSWORD_DEFAULT),
                'email' => $this->input->post('email'),
                'alamat' => $this->input->post('alamat'),
                'kota' => $this->input->post('kota'),
                'tanggallahir' => $this->input->post('tanggal'),
                'phone' => $this->input->post('phone'),
                'role_id' => 2,
                'is_active' => 1

            ];

            $this->db->insert('users', $data);
            $this->session->set_flashdata('message', '<div class="toast" role="alert" aria-live="assertive" aria-atomic="true">
            <div class="toast-header">
              <img src="..." class="rounded mr-2" alt="...">
              <strong class="mr-auto">Mampars Hotel</strong>
              <small class="text-muted">Anda telah berhasil mendaftarkan akun</small>
              <button type="button" class="ml-2 mb-1 close" data-dismiss="toast" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            
          </div>');
            redirect('auth');
        }
    }

    public function logout()
    {
        $this->session->unset_userdata('email');
        $this->session->unset_userdata('role_id');
        $this->session->set_flashdata('logout', '<div class="toast" role="alert" aria-live="assertive" aria-atomic="true">
            <div class="toast-header">
              <img src="..." class="rounded mr-2" alt="...">
              <strong class="mr-auto">Mampars Hotel</strong>
              <small class="text-muted">Anda telah Logout</small>
              <button type="button" class="ml-2 mb-1 close" data-dismiss="toast" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            
          </div>');
        redirect('auth');
    }
    public function create_captcha()
    {
        $path = './assets/captcha/';
        $options = array(
            'img_path' => $path,
            'img_url' => base_url('assets/captcha/'),
            'img_width' => '150',
            'img_height' => '30',
            'expiration' => 7200
        );

        $cap = create_captcha($options);
        $image = $cap['image'];

        $this->session->set_userdata('captchaword', $cap['word']);
        return $image;
    }

    public function check_captcha()
    {
        if ($this->input->post('captcha') == $this->session->userdata('captchaword')) {
            return true;
        } else {
            $this->form_validation->set_message('check_captcha', 'Captcha is wrong');
            return false;
        }
    }
    public function index2()
    {
        $path = './assets/captcha/';
        $options = array(
            'img_path' => $path,
            'img_url' => base_url('assets/captcha/'),
            'img_width' => '150',
            'img_height' => '30',
            'expiration' => 7200
        );

        $cap = create_captcha($options);
        $image = $cap['image'];

        $this->session->set_userdata('captchaword', $cap['word']);
        return $image;
        $this->form_validation->set_rules('captcha', 'captcha', 'trim|callback_check_captcha|required');

        if ($this->form_validation->run() == false) {
            $this->load->view('auth/login', array('img' => $this->create_captcha()));
        } else {
            echo 'Success Captcha Code';
        }
    }
}
