@extends('layout')
@section('judul')
Daftar Client
@endsection
@section('konten')
<br/>
<div class="row">
	<div class="col-lg-10">
		<input type="text" name="search" class="form-control" id="search" placeholder="search name">
	</div>
	<div class="col-lg-1">
		<a href="{{url('/profileMVC/create')}}" class="btn btn-primary">Add Client</a>
	</div>
</div>
<br/>
<section class="panel panel-default">
	<header class="panel-heading">
		<h3>Daftar Client</h3>
	</header>
	<div class="table-responsive">
		<table class="table table-striped table-bordered">
			<thead>
				<tr>
					<th>ID</th>
					<th>Image</th>
					<th>Full Names</th>
					<th>Sex</th>
					<th>Identity Card</th>
					<th>Birth Date</th>
					<th>Province</th>
					<th>District</th>
					<th>Sector</th>
					<th>Option</th>
				</tr>
			</thead>
			<tbody>
				@foreach($data as $client)
				<tr>
					<td>{{$client->id}}</td>
					<td><img src="images/<?php echo $client->image; ?>" style="max-width: 10em; max-height: 10em;"></td>
					<td>{{$client->name}}</td>
					<td>{{$client->sex}}</td>
					<td>{{$client->idcard}}</td>
					<td>{{$client->birthdate}}</td>
					<td>{{$client->province}}</td>
					<td>{{$client->district}}</td>
					<td>{{$client->sector}}</td>
					<td>
						<a href="{{url('profileMVC/'.$client->id.'/edit')}}" class="btn btn-success" title="edit {{$client->name}}"><i class="glyphicon glyphicon-edit"></i></a>

						<form action="{{ url('profileMVC/'.$client->id) }}" method="post">
							{{csrf_field()}} 
							<br/>
							<input type="hidden" name="_method" value="delete">
							<button type="submit" class="btn btn-danger" title="delete {{$client->name}}"><i class="glyphicon glyphicon-trash"></i></button>
						</form>
					</td>
				</tr>
				@endforeach
			</tbody>
		</table>
	</div>

</section>
@endsection
@section('script')
<script type="text/javascript">
	$(document).ready(function(){
		$('#search').on('keyup',function(){
			$value = $(this).val();
			$.ajax({
				type : 'get',
				url : '{{URL::to('search')}}',
				data : {'search':$value},
				success:function(data){
					$('tbody').html(data);
				}
			});
		});
	});
</script>
@endsection