package org.perpus.dao;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
 
import org.perpus.model.Book;
import org.perpus.util.DBUtil;

public class BookDAOImplementation implements BookDAO {
	private Connection conn;
	 
    public BookDAOImplementation() {
        conn = DBUtil.getConnection();
    }
    
    @Override
    public void addBook( Book book ) {
        try {
            String query = "insert into book (pengarang,judul,jenis) values (?,?,?)";
            PreparedStatement preparedStatement = conn.prepareStatement( query );
            preparedStatement.setString( 1, book.getPengarang() );
            preparedStatement.setString( 2, book.getJudul() );
            preparedStatement.setString( 3, book.getJenis() );
            preparedStatement.setString( 4, book.getIsbn() );
            preparedStatement.executeUpdate();
            preparedStatement.close();
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }
    
    @Override
    public void deleteBook( int bookId ) {
        try {
            String query = "delete from book where bookId=?";
            PreparedStatement preparedStatement = conn.prepareStatement(query);
            preparedStatement.setInt(1, bookId);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }
    
    @Override
    public void updateBook( Book book ) {
        try {
            String query = "update book set pengarang=?, judul=?, jenis=?, isbn=? where bookId=?";
            PreparedStatement preparedStatement = conn.prepareStatement( query );
            preparedStatement.setString( 1, book.getPengarang() );
            preparedStatement.setString( 2, book.getJudul() );
            preparedStatement.setString( 3, book.getJenis() );
            preparedStatement.setString( 4, book.getIsbn() );
            preparedStatement.setInt(5, book.getBookId());
            preparedStatement.executeUpdate();
            preparedStatement.close();
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }
    
    @Override
    public List<Book> getAllBooks() {
        List<Book> books = new ArrayList<Book>();
        try {
            Statement statement = conn.createStatement();
            ResultSet resultSet = statement.executeQuery( "select * from book" );
            while( resultSet.next() ) {
                Book book = new Book();
                book.setBookId( resultSet.getInt( "bookId" ) );
                book.setPengarang( resultSet.getString( "pengarang" ) );
                book.setJudul( resultSet.getString( "judul" ) );
                book.setJenis( resultSet.getString( "jenis" ) );
                book.setIsbn( resultSet.getString( "isbn" ) );
                books.add(book);
            }
            resultSet.close();
            statement.close();
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return books;
    }
    
    @Override
    public Book getBookByIsbn( int bookId ) {
        Book book = new Book();
        try {
            String query = "select * from book where bookId=?";
            PreparedStatement preparedStatement = conn.prepareStatement( query );
            preparedStatement.setInt(1, bookId);
            ResultSet resultSet = preparedStatement.executeQuery();
            while( resultSet.next() ) {
                book.setBookId( resultSet.getInt( "bookId" ) );
                book.setPengarang( resultSet.getString( "pengarang" ) );
                book.setJudul( resultSet.getString( "judul" ) );
                book.setJenis( resultSet.getString( "jenis" ) );
                book.setIsbn( resultSet.getString( "isbn" ) );
            }
            resultSet.close();
            preparedStatement.close();
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return book;
    }
}
