package org.perpus.controller;

import java.io.IOException;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
 
import org.perpus.dao.BookDAO;
import org.perpus.dao.BookDAOImplementation;
import org.perpus.model.Book;

@WebServlet("/BookController")
public class BookController extends HttpServlet {
	private BookDAO dao;
	private static final long serialVersionUID = 1L;
	public static final String lIST_BOOK = "/listBook.jsp";
    public static final String INSERT_OR_EDIT = "/book.jsp";
	
    public BookController() {
    	dao = new BookDAOImplementation();
    }

	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		String forward = "";
        String action = request.getParameter( "action" );
 
        if( action.equalsIgnoreCase( "delete" ) ) {
            forward = lIST_BOOK;
            int bookId = Integer.parseInt( request.getParameter("bookId") );
            dao.deleteBook(bookId);
            request.setAttribute("books", dao.getAllBooks() );
        }
        else if( action.equalsIgnoreCase( "edit" ) ) {
            forward = INSERT_OR_EDIT;
            int bookId = Integer.parseInt( request.getParameter("bookId") );
            Book book = dao.getBookByIsbn(bookId);
            request.setAttribute("book", book);
        }
        else if( action.equalsIgnoreCase( "insert" ) ) {
            forward = INSERT_OR_EDIT;
        }
        else {
            forward = lIST_BOOK;
            request.setAttribute("books", dao.getAllBooks() );
        }
        RequestDispatcher view = request.getRequestDispatcher( forward );
        view.forward(request, response);
	}

	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		 Book book = new Book();
		 	book.setPengarang( request.getParameter( "pengarang" ) );
		 	book.setJudul( request.getParameter( "judul" ) );
		 	book.setJenis( request.getParameter( "jenis" ) );
		 	book.setIsbn( request.getParameter( "isbn" )  );
	        String bookId = request.getParameter("bookId");
	 
	        if( bookId == null || bookId.isEmpty() )
	            dao.addBook(book);
	        else {
	        	book.setBookId( Integer.parseInt(bookId) );
	            dao.updateBook(book);
	        }
	        RequestDispatcher view = request.getRequestDispatcher( lIST_BOOK);
	        request.setAttribute("books", dao.getAllBooks());
	        view.forward(request, response);
	}
}
