package org.perpustakaanku.model;


import java.util.ArrayList;
import java.util.List;

import org.perpustakaanku.model.Buku;



public class DaftarBuku {

	private static List<Buku> bukus = new ArrayList<>();

	static{
		bukus.add(new Buku("1","Laravel","Awan Pribadi","LokoPedia",2));
		bukus.add(new Buku("2","Matdis","Anthon","Gramedia",1));
		bukus.add(new Buku("3","Longman TOEFL Test","Dewi","Philips",2));
		bukus.add(new Buku("4","Motivasi","Ary Cahya","Grafindo",3));
		bukus.add(new Buku("5","PABWE","Billy","Media",1));
	}
	
	/**
	 * @return the bukus
	 */
	public static List<Buku> getBukus() {
		return bukus;
	}

	/**
	 * @param bukus the bukus to set
	 */
	public static void setBukus(List<Buku> bukus) {
		DaftarBuku.bukus = bukus;
	}
	
	/**
	 * 
	 * @param buku the bukus to add
	 */
	public static void addToListBukus(Buku buku){
		DaftarBuku.bukus.add(buku);
	}
	
	/**
	 * 
	 * @param judul judul from bukus
	 * @return bukus which has the same judul
	 */
	public static Buku getBukuFromList(String judul){
		for(Buku buku : DaftarBuku.bukus){
			if(buku.getJudul().compareTo(judul)==0){
				return buku;
			}
		}
		return null;
	}
	
	public static boolean isBukuExist(String judul){
		for(Buku buku : bukus){
			if(buku.getJudul().compareTo(judul)==0 && buku.getJumlah()!=0){
				return true;
			}
		}
		return false;
	}
}
