<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Person;
class PersonController extends Controller
{
    public function index(){
    	$persons = Person::all();
    	return view('persons.index',['persons' => $persons]);
    }

    public function create(){
    	return view('persons.insert');
    }
 
    public function findByID($id){
    	$person = Person::findOrFail($id);
    	if($person!=null){
		    $person->image = $request->image;
		    $person->fullnames = $request->fullnames;
		    $person->sex = $request->sex;
		    $person->identitycard = $request->identitycard;
		    $person->birthdate = $request->birthdate;
		    $person->province = $request->province;
		    $person->district = $request->district;
		    $person->sector = $request->sector;
		    $person->cellar = $request->cellar; 
		    return $person;
		}
    }

    public function findByName($name){
    	$i=0;
    	$list = [];
    	$person = Person::findOrFail($name);
    	while($person!=null){
		    $person->image = $request->image;
		    $person->fullnames = $request->fullnames;
		    $person->sex = $request->sex;
		    $person->identitycard = $request->identitycard;
		    $person->birthdate = $request->birthdate;
		    $person->province = $request->province;
		    $person->district = $request->district;
		    $person->sector = $request->sector;
		    $person->cellar = $request->cellar;
		    $list[$i] = $person;
		    $i++;
		}
		return $list;
    }

    public function edit($id){
    	$person = Person::findOrFail($id);
    	return view('persons.edit', compact('person'));
    }

    public function update(Request $request, $id){
	   	$this->validate($request, ['image' => 'required', 'fullnames' => 'required', 'sex' => 'required', 'identitycard' => 'required', 'birthdate' => 'required', 'province' => 'required', 'district' => 'required', 'sector' => 'required', 'cellar' => 'required',  
	    ]);    	

	    $person = Person::findOrFail($id);
	    $person->image = $request->image;
	    $person->fullnames = $request->fullnames;
	    $person->sex = $request->sex;
	    $person->identitycard = $request->identitycard;
	    $person->birthdate = $request->birthdate;
	    $person->province = $request->province;
	    $person->district = $request->district;
	    $person->sector = $request->sector;
	    $person->cellar = $request->cellar; 
	    $person->save();
	    return redirect()->route('person.index')->with('alert-success', 'Data has been saved!');	    

    }

    public function store(Request $request){
    	$this->validate($request, ['image' => 'required', 'fullnames' => 'required', 'sex' => 'required', 'identitycard' => 'required', 'birthdate' => 'required', 'province' => 'required', 'district' => 'required', 'sector' => 'required', 'cellar' => 'required',  
    ]);

    $person = new Person;
    $person->image = $request->image;
    $person->fullnames = $request->fullnames;
    $person->sex = $request->sex;
    $person->identitycard = $request->identitycard;
    $person->birthdate = $request->birthdate;
    $person->province = $request->province;
    $person->district = $request->district;
    $person->sector = $request->sector;
    $person->cellar = $request->cellar; 
    $person->save();
    return redirect()->route('person.index')->with('alert-success', 'Data has been saved!');
    }
 
    public function destroy($id){
	    $person = Person::findOrFail($id);
	    $person->delete();
    return redirect()->route('person.index')->with('alert-success', 'Data has been saved!');
    }
}
